/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser;

import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.views.IFilterAreaProvider;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.simantics.views.swt.ModelledView;

public class ModelBrowser
extends ModelledView {
    private static final Set<String> uiContexts = CollectionUtils.toSet((Object[])new String[]{"org.simantics.modeling.ui.modelBrowser", "org.simantics.modeling.ui.context"});

    protected Set<String> getUiContexts() {
        return uiContexts;
    }

    protected IPropertyPage getPropertyPage() {
        return new StandardPropertyPage(this.getSite());
    }

    public Object getAdapter(Class adapter) {
        if (GraphExplorer.class == adapter) {
            return this.tryGetExplorer((Control)this.container);
        }
        if (BrowseContext.class == adapter) {
            return this.tryGetBrowseContext((Control)this.container);
        }
        if (IFilterAreaProvider.class == adapter) {
            return this.tryGetFilterAreaProvider((Control)this.container);
        }
        return super.getAdapter(adapter);
    }

    private BrowseContext tryGetBrowseContext(Control control) {
        return this.tryGetObject(control, new ControlFilter<BrowseContext>(){

            @Override
            public BrowseContext accept(Control control) {
                return control instanceof IAdaptable ? (BrowseContext)((IAdaptable)control).getAdapter(BrowseContext.class) : null;
            }
        });
    }

    private IFilterAreaProvider tryGetFilterAreaProvider(Control control) {
        return this.tryGetObject(control, new ControlFilter<IFilterAreaProvider>(){

            @Override
            public IFilterAreaProvider accept(Control control) {
                return !control.isDisposed() && control instanceof IFilterAreaProvider ? (IFilterAreaProvider)control : null;
            }
        });
    }

    private GraphExplorer tryGetExplorer(Control control) {
        return this.tryGetObject(control, new ControlFilter<GraphExplorer>(){

            @Override
            public GraphExplorer accept(Control control) {
                return control.isDisposed() ? null : (GraphExplorer)control.getData("GraphExplorer");
            }
        });
    }

    private <T> T tryGetObject(Control control, ControlFilter<T> filter) {
        if (control.isDisposed()) {
            return null;
        }
        T t = filter.accept(control);
        if (t != null) {
            return t;
        }
        if (control instanceof Composite) {
            Composite c = (Composite)control;
            Control[] controlArray = c.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                t = this.tryGetObject(child, filter);
                if (t != null) {
                    return t;
                }
                ++n2;
            }
        }
        return null;
    }

    static interface ControlFilter<T> {
        public T accept(Control var1);
    }
}

