/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.function;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.ExplorerState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContexts;
import org.simantics.browsing.ui.model.nodetypes.EntityNodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.SpecialNodeType;
import org.simantics.browsing.ui.swt.GraphExplorerStateBean;
import org.simantics.browsing.ui.swt.GraphExplorerStateNodeBean;
import org.simantics.browsing.ui.swt.NodeContextValueBean;
import org.simantics.browsing.ui.swt.StringArrayBean;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.ArrayListBinding;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.StringUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Procedure;
import org.simantics.modeling.typicals.TypicalUtil;
import org.simantics.modeling.ui.typicals.NewTypicalDiagramInstance;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class All {
    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable singleVariableSelection(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Resource")
    public static Resource projectSelection(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return Simantics.getProjectResource();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> StatePersistor")
    public static StatePersistor standardPersistor(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        String configurationId = (String)context.getParent(graph).getPossiblePropertyValue(graph, "browseContext");
        return new StandardPersistor(configurationId);
    }

    @SCLValue(type="Resource -> Resource -> Resource")
    public static Resource standardTypicalInstantiator(Resource model, final Resource target) throws DatabaseException {
        final Session session = Simantics.getSession();
        Collection typicals = TypicalUtil.findModelTypicals((RequestProcessor)session, (Resource)model);
        if (typicals.isEmpty()) {
            ShowMessage.showInformation((String)"No Typical Diagrams", (String)"There are no typical diagrams in the selected model. Cannot instantiate.");
            return null;
        }
        final Collection namedTypicals = TypicalUtil.toNamedResources((RequestProcessor)session, (Collection)typicals);
        return (Resource)TypicalUtil.syncExec((Callback)new Callback<Procedure<Resource>>(){

            public void run(final Procedure<Resource> procedure) {
                NewTypicalDiagramInstance.asyncQueryFromList(namedTypicals, new Callback<NamedResource>(){

                    public void run(NamedResource selectedTypical) {
                        if (selectedTypical == null) {
                            procedure.execute(null);
                            return;
                        }
                        try {
                            try {
                                session.syncRequest(TypicalUtil.instantiateTemplate((Resource)target, (NamedResource)selectedTypical, (Callback)new Callback<Pair<WriteGraph, Resource>>(){

                                    public void run(Pair<WriteGraph, Resource> instance) {
                                        try {
                                            HashSet customlyNamed = new HashSet();
                                            TypicalUtil.applyTypicalModuleNames((WriteGraph)((WriteGraph)instance.first), (Resource)((Resource)instance.second), customlyNamed);
                                            TypicalUtil.generateFreshModuleNames((WriteGraph)((WriteGraph)instance.first), (Resource)((Resource)instance.second), customlyNamed);
                                            procedure.execute((Object)((Resource)instance.second));
                                            NewTypicalDiagramInstance.asyncPerformDefaultAction(session, instance.second);
                                        }
                                        catch (DatabaseException e) {
                                            procedure.exception((Throwable)e);
                                        }
                                    }
                                }));
                            }
                            catch (Throwable e) {
                                procedure.exception(e);
                                procedure.execute(null);
                            }
                        }
                        finally {
                            procedure.execute(null);
                        }
                    }
                });
            }
        });
    }

    static class StandardPersistor
    implements StatePersistor {
        final String configurationId;

        StandardPersistor(String configurationId) {
            this.configurationId = configurationId;
        }

        private File getMementoFile(File stateLocation, NodeContext root) {
            Object input;
            if (root != null && (input = root.getConstant(BuiltinKeys.INPUT)) instanceof Resource) {
                Resource r = (Resource)input;
                return new File(stateLocation, StringUtil.escapeToFileName((String)(String.valueOf(this.configurationId) + "#" + r.getResourceId() + ".ge")));
            }
            return null;
        }

        private NodeContext.ConstantKey<?> decodeKey(String name) {
            if (BuiltinKeys.INPUT.getClass().getName().equals(name)) {
                return BuiltinKeys.INPUT;
            }
            if (BuiltinKeys.BROWSE_CONTEXT.getClass().getName().equals(name)) {
                return BuiltinKeys.BROWSE_CONTEXT;
            }
            if (BuiltinKeys.ACTION_BROWSE_CONTEXT.getClass().getName().equals(name)) {
                return BuiltinKeys.ACTION_BROWSE_CONTEXT;
            }
            if (NodeType.TYPE.getClass().getName().equals(name)) {
                return NodeType.TYPE;
            }
            throw new IllegalArgumentException(name);
        }

        private Object decodeValue(NodeContext.ConstantKey<?> key, Bean bean) throws Exception {
            if (key == BuiltinKeys.BROWSE_CONTEXT) {
                String[] uris = (String[])bean.getField("strings");
                return uris == null ? null : BrowseContexts.toBrowseContext((RequestProcessor)Simantics.getSession(), (String[])uris);
            }
            if (key == BuiltinKeys.ACTION_BROWSE_CONTEXT) {
                String[] uris = (String[])bean.getField("strings");
                return uris == null ? null : BrowseContexts.toActionBrowseContext((RequestProcessor)Simantics.getSession(), (String[])uris);
            }
            String name = (String)bean.getField("name");
            if (Resource.class.getName().equals(name)) {
                return bean.getField("resource", Bindings.getBinding(Resource.class));
            }
            if (EntityNodeType.class.getName().equals(name)) {
                List entityType = (List)bean.getField("resources", (Binding)new ArrayListBinding(Bindings.getBinding(Resource.class)));
                return EntityNodeType.create((Collection)entityType);
            }
            if (SpecialNodeType.class.getName().equals(name)) {
                Resource resource = (Resource)bean.getField("resource", Bindings.getBinding(Resource.class));
                String contentType = (String)bean.getField("className");
                Class<?> clazz = this.getClass().getClassLoader().loadClass(contentType);
                return new SpecialNodeType(resource, clazz);
            }
            throw new IllegalArgumentException("key = " + key + ", bean = " + bean);
        }

        private List<NodeContext> buildNodeContextArray(GraphExplorerStateNodeBean[] beans) throws Exception {
            ArrayList<NodeContext> result = new ArrayList<NodeContext>(beans.length);
            GraphExplorerStateNodeBean[] graphExplorerStateNodeBeanArray = beans;
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                GraphExplorerStateNodeBean bean = graphExplorerStateNodeBeanArray[n2];
                NodeContext node = this.buildNodeContext(bean);
                if (node != null) {
                    result.add(node);
                }
                ++n2;
            }
            return result;
        }

        public NodeContext buildNodeContext(GraphExplorerStateNodeBean node) throws Exception {
            if (node == null) {
                return null;
            }
            ArrayList<Object> keysAndValues = new ArrayList<Object>(node.map.size());
            for (Map.Entry entry : node.map.entrySet()) {
                NodeContext.ConstantKey<?> key = this.decodeKey((String)entry.getKey());
                Object value = this.decodeValue(key, (Bean)entry.getValue());
                keysAndValues.add(key);
                keysAndValues.add(value);
            }
            return NodeContextBuilder.buildWithData((Object[])keysAndValues.toArray());
        }

        private List<GraphExplorerStateNodeBean> buildNodeBeanArray(Collection<NodeContext> nodes) {
            ArrayList<GraphExplorerStateNodeBean> result = new ArrayList<GraphExplorerStateNodeBean>(nodes.size());
            for (NodeContext node : nodes) {
                GraphExplorerStateNodeBean bean = this.buildNodeBean(node);
                if (bean == null) continue;
                result.add(bean);
            }
            return result;
        }

        private List<GraphExplorerStateNodeBean> buildNodeBeanArray(NodeContext[] nodes) {
            return this.buildNodeBeanArray(Arrays.asList(nodes));
        }

        public GraphExplorerStateNodeBean buildNodeBean(NodeContext nodeContext) {
            if (nodeContext instanceof NodeContextBuilder.MapNodeContext) {
                NodeContextBuilder.MapNodeContext ctx = (NodeContextBuilder.MapNodeContext)nodeContext;
                GraphExplorerStateNodeBean node = new GraphExplorerStateNodeBean();
                for (NodeContext.ConstantKey key : ctx.getKeys()) {
                    String[] uris;
                    Object value = ctx.getConstant(key);
                    if (value instanceof Resource) {
                        node.map.put(key.getClass().getName(), new NodeContextValueBean((Resource)value));
                        continue;
                    }
                    if (value instanceof EntityNodeType) {
                        node.map.put(key.getClass().getName(), new NodeContextValueBean((EntityNodeType)value));
                        continue;
                    }
                    if (value instanceof SpecialNodeType) {
                        node.map.put(key.getClass().getName(), new NodeContextValueBean((SpecialNodeType)value));
                        continue;
                    }
                    if (key == BuiltinKeys.BROWSE_CONTEXT) {
                        uris = value != null ? ((BrowseContext)value).getURIs() : null;
                        node.map.put(key.getClass().getName(), new StringArrayBean(uris));
                        continue;
                    }
                    if (key != BuiltinKeys.ACTION_BROWSE_CONTEXT) continue;
                    uris = value != null ? ((ActionBrowseContext)value).getURIs() : null;
                    node.map.put(key.getClass().getName(), new StringArrayBean(uris));
                }
                return node;
            }
            return null;
        }

        public ExplorerState deserialize(File stateLocation, NodeContext root) {
            if (stateLocation == null) {
                return ExplorerState.EMPTY;
            }
            if (root == null) {
                return ExplorerState.EMPTY;
            }
            File memento = this.getMementoFile(stateLocation, root);
            if (memento == null) {
                return ExplorerState.EMPTY;
            }
            try {
                byte[] stateBytes = FileUtils.readFile((File)memento);
                if (stateBytes == null) {
                    return ExplorerState.EMPTY;
                }
                GraphExplorerStateBean stateBean = new GraphExplorerStateBean();
                stateBean.deserialize(stateBytes);
                NodeContext[] topNodePath = this.buildNodeContextArray(stateBean.topNodePath).toArray(NodeContext.NONE);
                List<NodeContext> expandedNodes = this.buildNodeContextArray(stateBean.expandedNodes);
                return new ExplorerState(topNodePath, stateBean.topNodePathChildIndexes, expandedNodes, stateBean.columnWidths);
            }
            catch (FileNotFoundException e) {
                return ExplorerState.EMPTY;
            }
            catch (Throwable t) {
                Logger.defaultLogError((Throwable)t);
                return ExplorerState.EMPTY;
            }
        }

        public void serialize(File stateLocation, NodeContext root, ExplorerState state) {
            if (stateLocation == null) {
                return;
            }
            if (root == null) {
                return;
            }
            File memento = this.getMementoFile(stateLocation, root);
            if (memento == null) {
                return;
            }
            Object input = root.getConstant(BuiltinKeys.INPUT);
            if (input instanceof Resource) {
                GraphExplorerStateBean ib = new GraphExplorerStateBean();
                ib.topNodePath = this.buildNodeBeanArray(state.topNodePath).toArray(GraphExplorerStateNodeBean.NONE);
                ib.topNodePathChildIndexes = state.topNodePathChildIndex;
                ib.expandedNodes = this.buildNodeBeanArray(state.expandedNodes).toArray(GraphExplorerStateNodeBean.NONE);
                ib.columnWidths = state.columnWidths;
                try {
                    byte[] bytes = ib.serialize();
                    FileUtils.writeFile((File)memento, (byte[])bytes);
                }
                catch (Throwable t) {
                    Logger.defaultLogError((Throwable)t);
                }
            }
        }
    }
}

