/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.expression;

import java.util.HashMap;
import java.util.Stack;
import org.simantics.basicexpression.analysis.DepthFirstAdapter;
import org.simantics.basicexpression.node.AConstantValue;
import org.simantics.basicexpression.node.ADivMultiplicative;
import org.simantics.basicexpression.node.AMultMultiplicative;
import org.simantics.basicexpression.node.APlusExpression;
import org.simantics.basicexpression.node.AStringValue;
import org.simantics.db.ReadGraph;
import org.simantics.db.layer0.adapter.Function;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.Triple;

public class InvertBasicExpressionVisitor
extends DepthFirstAdapter {
    final ReadGraph graph;
    final Variable property;
    Stack<Object> stack = new Stack();
    HashMap<String, Function> builtins = new HashMap();

    public InvertBasicExpressionVisitor(ReadGraph graph, Variable property) {
        this.graph = graph;
        this.property = property;
    }

    public Object getResult() {
        return this.stack.pop();
    }

    public void outAConstantValue(AConstantValue node) {
        this.stack.push(Double.valueOf(node.toString()));
    }

    public void outAStringValue(AStringValue node) {
        String value = node.toString();
        this.stack.push(Triple.make((Object)1.0, (Object)0.0, (Object)value.substring(1, value.length() - 2).trim()));
    }

    public void outAPlusExpression(APlusExpression node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            Triple p = (Triple)o2;
            this.stack.push(Triple.make((Object)((Double)p.first), (Object)((Double)p.second + (Double)o1), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)((Double)p.first), (Object)((Double)p.second + (Double)o2), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o1 + (Double)o2);
        } else {
            this.stack.push(Double.NaN);
        }
    }

    public void outAMinusExpression(APlusExpression node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            Triple p = (Triple)o2;
            this.stack.push(Triple.make((Object)(-((Double)p.first).doubleValue()), (Object)((Double)o1 - (Double)p.second), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)((Double)p.first), (Object)((Double)p.second - (Double)o2), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o1 - (Double)o2);
        } else {
            this.stack.push(Double.NaN);
        }
    }

    public void outAMultMultiplicative(AMultMultiplicative node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            Triple p = (Triple)o2;
            this.stack.push(Triple.make((Object)((Double)p.first * (Double)o1), (Object)((Double)p.second * (Double)o1), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)((Double)p.first * (Double)o2), (Object)((Double)p.second * (Double)o2), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o1 * (Double)o2);
        } else {
            this.stack.push(Double.NaN);
        }
    }

    public void outADivMultiplicative(ADivMultiplicative node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            this.stack.push(Double.NaN);
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)((Double)p.first / (Double)o2), (Object)((Double)p.second / (Double)o2), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o1 / (Double)o2);
        } else {
            this.stack.push(Double.NaN);
        }
    }
}

