/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.expression;

import org.simantics.basicexpression.Expressions;
import org.simantics.basicexpression.analysis.DepthFirstAdapter;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.EquationExpression;
import org.simantics.db.layer0.variable.Expression;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.modeling.ui.expression.BasicExpressionVisitor;
import org.simantics.modeling.ui.expression.InvertBasicExpressionVisitor;
import org.simantics.utils.datastructures.Triple;

public class BasicExpression
implements Expression,
EquationExpression {
    private final Resource expression;

    public BasicExpression(Resource expression) {
        this.expression = expression;
    }

    public <T> T evaluate(ReadGraph graph, Variable property, Binding binding) throws DatabaseException {
        return this.evaluate(graph, property);
    }

    public <T> T evaluate(ReadGraph graph, Variable property) throws DatabaseException {
        String expressionString = (String)graph.getValue(this.expression, (Binding)Bindings.STRING);
        BasicExpressionVisitor visitor = new BasicExpressionVisitor(graph, property);
        Expressions.evaluate((String)expressionString, (DepthFirstAdapter)visitor);
        return (T)visitor.getResult();
    }

    public <T> void invert(WriteGraph graph, Variable property, T value, Binding binding) throws DatabaseException {
        String expressionString = (String)graph.getValue(this.expression, (Binding)Bindings.STRING);
        InvertBasicExpressionVisitor visitor = new InvertBasicExpressionVisitor((ReadGraph)graph, property);
        Expressions.evaluate((String)expressionString, (DepthFirstAdapter)visitor);
        Object pair = visitor.getResult();
        if (pair instanceof Triple) {
            Triple data = (Triple)pair;
            if (Math.abs((Double)data.first) > 1.0E-9) {
                Double inverted = ((Double)value - (Double)data.second) / (Double)data.first;
                String target = (String)data.third;
                Variable targetVariable = property.browse((ReadGraph)graph, target);
                targetVariable.setValue(graph, (Object)inverted, binding);
            }
        }
    }

    public boolean isInvertible(ReadGraph graph, Variable property) throws DatabaseException {
        String expressionString = (String)graph.getValue(this.expression, (Binding)Bindings.STRING);
        InvertBasicExpressionVisitor visitor = new InvertBasicExpressionVisitor(graph, property);
        Expressions.evaluate((String)expressionString, (DepthFirstAdapter)visitor);
        Object value = visitor.getResult();
        return value instanceof Triple;
    }
}

