/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.Set;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.layer0.utils.operations.IOperation;
import org.simantics.modeling.ModelingOperationConstants;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.actions.NavigateToTarget;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.utils.datastructures.persistent.ContextMap;
import org.simantics.utils.datastructures.persistent.IContextMap;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class StructuralBrowsingHandler
extends AbstractCanvasParticipant {
    @DependencyReflection.Dependency
    Selection selection;
    IWorkbenchPartSite site;
    ISessionContext sessionContext;
    IResourceEditorInput2 input;

    public StructuralBrowsingHandler(IWorkbenchPartSite site, ISessionContext sessionContext, IResourceEditorInput2 input) {
        assert (site != null);
        this.site = site;
        this.sessionContext = sessionContext;
        this.input = input;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleDoubleClick(MouseEvent.MouseDoubleClickedEvent me) {
        IElement e;
        Object data;
        if (this.sessionContext == null) {
            return false;
        }
        Set sel = this.selection.getSelection(0);
        if (sel.size() == 1 && (data = (e = (IElement)sel.iterator().next()).getHint(ElementHints.KEY_OBJECT)) instanceof Resource) {
            final Resource element = (Resource)data;
            final int stateMask = me.stateMask;
            try {
                return (Boolean)this.sessionContext.getSession().syncRequest((Read)new UniqueRead<Boolean>(){

                    public Boolean perform(ReadGraph graph) throws DatabaseException {
                        return StructuralBrowsingHandler.this.browse(graph, element, stateMask);
                    }
                });
            }
            catch (DatabaseException e1) {
                ErrorLogger.defaultLogError((Throwable)e1);
            }
        }
        return false;
    }

    private boolean browse(ReadGraph graph, Resource element, int stateMask) throws DatabaseException {
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(element, dr.Flag)) {
            ContextMap parameters = new ContextMap();
            parameters.put(ModelingOperationConstants.WORKBENCH_WINDOW, (Object)this.site.getWorkbenchWindow());
            parameters.put(ModelingOperationConstants.WORKBENCH_PART, (Object)this.site.getPart());
            parameters.put(IOperation.SUBJECT, (Object)element);
            new NavigateToTarget().exec(graph.getSession(), (IContextMap)parameters);
            return FlagUtil.isJoined((ReadGraph)graph, (Resource)element);
        }
        if ((stateMask & 0x40) == 0) {
            return false;
        }
        Resource component = graph.getPossibleObject(element, mr.ElementToComponent);
        if (component == null) {
            return false;
        }
        Resource type = graph.getPossibleType(component, sr.Component);
        if (type == null) {
            return false;
        }
        Resource definedBy = graph.getPossibleObject(type, sr.IsDefinedBy);
        if (definedBy == null) {
            return false;
        }
        final Resource diagram = graph.getPossibleObject(definedBy, mr.CompositeToDiagram);
        if (diagram == null) {
            return false;
        }
        if (this.input.getRVI() == null) {
            return false;
        }
        final Resource model = this.input.getModel(graph);
        RVI rvi = RVI.fromResourceFormat((RequestProcessor)graph, (String)this.input.getRVI());
        Variable base = Variables.getConfigurationContext((ReadGraph)graph, (Resource)this.input.getModel(graph));
        Variable current = rvi.resolve(graph, base);
        Variable subprocess = current.browse(graph, component);
        final RVI subprocessRVI = subprocess.getRVI(graph);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    WorkbenchUtils.openEditor((String)StructuralBrowsingHandler.this.site.getId(), (IEditorInput)new ResourceEditorInput2(StructuralBrowsingHandler.this.site.getId(), diagram, model, subprocessRVI));
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        return true;
    }
}

