/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.Alignment;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagram.monitor.MonitorClassFactory2;
import org.simantics.modeling.ui.diagramEditor.PopulateElementDropParticipant;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class PopulateElementMonitorDropParticipant
extends PopulateElementDropParticipant
implements IDropTargetParticipant {
    private static final boolean DEBUG = false;
    double scaleX;
    double scaleY;
    String typeURI;

    public PopulateElementMonitorDropParticipant(GraphToDiagramSynchronizer synchronizer, double scaleX, double scaleY) {
        super(synchronizer);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.typeURI = "http://www.simantics.org/Diagram-2.2/Monitor";
    }

    public PopulateElementMonitorDropParticipant(GraphToDiagramSynchronizer synchronizer, String typeURI, double scaleX, double scaleY) {
        super(synchronizer);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.typeURI = typeURI;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde, IDnDContext dp) {
        Transferable tr = dtde.getTransferable();
        if (tr.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
            Session session = this.synchronizer.getSession();
            Object obj = null;
            try {
                IStructuredSelection sel;
                obj = tr.getTransferData(LocalObjectTransferable.FLAVOR);
                if (!(obj instanceof IStructuredSelection)) {
                    obj = LocalObjectTransfer.getTransfer().getObject();
                }
                if (obj instanceof IStructuredSelection && !(sel = (IStructuredSelection)obj).isEmpty()) {
                    Variable property = WorkbenchSelectionUtils.getPossibleVariable((Object)sel);
                    if (property == null && (property = (Variable)ISelectionUtils.getSinglePossibleKey((Object)sel, (IHintContext.Key)SelectionHints.KEY_SELECTION_PROPERTY, Variable.class)) == null) {
                        return;
                    }
                    List items = (List)session.syncRequest((Read)new UnaryRead<Variable, List<ElementClassDragItem>>(property){

                        private Triple<Variable, Resource, IElement> findElementInDiagram(ReadGraph graph, Variable property, boolean propertyRoleFound) throws DatabaseException {
                            Resource elementResource;
                            Resource represents;
                            if (property == null) {
                                return null;
                            }
                            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                            Resource diagram = (Resource)PopulateElementMonitorDropParticipant.this.synchronizer.getDiagram().getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
                            if (!propertyRoleFound) {
                                Variables.Role role = (Variables.Role)property.getPossiblePropertyValue(graph, "Role");
                                boolean bl = propertyRoleFound = role == Variables.Role.PROPERTY;
                            }
                            if ((represents = property.getPossibleRepresents(graph)) != null && (elementResource = graph.getPossibleObject(represents, MOD.ComponentToElement)) != null && propertyRoleFound) {
                                Resource elementDiagram = OrderedSetUtils.getSingleOwnerList((ReadGraph)graph, (Resource)elementResource, (Resource)DIA.Diagram);
                                if (diagram.equals(elementDiagram)) {
                                    IElement tailNodeElement;
                                    Resource tailNode;
                                    DataElementMap map = (DataElementMap)PopulateElementMonitorDropParticipant.this.synchronizer.getDiagram().getDiagramClass().getSingleItem(DataElementMap.class);
                                    IElement parentElement = map.getElement(PopulateElementMonitorDropParticipant.this.synchronizer.getDiagram(), (Object)elementResource);
                                    if (graph.isInstanceOf(elementResource, DIA.Connection) && (tailNode = ConnectionUtil.getConnectionTailNode((ReadGraph)graph, (Resource)elementResource)) != null && (tailNodeElement = map.getElement(PopulateElementMonitorDropParticipant.this.synchronizer.getDiagram(), (Object)tailNode)) != null) {
                                        parentElement = tailNodeElement;
                                    }
                                    return Triple.make((Object)property, (Object)represents, (Object)parentElement);
                                }
                                return Triple.make((Object)property, (Object)represents, null);
                            }
                            return this.findElementInDiagram(graph, property.browsePossible(graph, "."), propertyRoleFound);
                        }

                        public List<ElementClassDragItem> perform(ReadGraph graph) throws DatabaseException {
                            Triple<Variable, Resource, IElement> match = this.findElementInDiagram(graph, (Variable)this.parameter, false);
                            if (match == null) {
                                return Collections.emptyList();
                            }
                            String rvi = Variables.getRVI((ReadGraph)graph, (Variable)((Variable)match.first), (Variable)((Variable)this.parameter));
                            Resource type = graph.getResource(PopulateElementMonitorDropParticipant.this.typeURI);
                            ElementClassDragItem item = new ElementClassDragItem(MonitorClassFactory2.createMonitorClass(type, (IElement)match.third, new HashMap<String, String>(), match.second, rvi, PopulateElementMonitorDropParticipant.this.scaleX, PopulateElementMonitorDropParticipant.this.scaleY));
                            item.getHintContext().setHint(ElementHints.KEY_HORIZONTAL_ALIGN, (Object)Alignment.LEADING);
                            if (match.third != null) {
                                item.getHintContext().setHint(ElementHints.KEY_PARENT_ELEMENT, match.third);
                            }
                            AffineTransform initialTr = AffineTransform.getScaleInstance(PopulateElementMonitorDropParticipant.this.scaleX, PopulateElementMonitorDropParticipant.this.scaleY);
                            item.getHintContext().setHint(ElementHints.KEY_TRANSFORM, (Object)initialTr);
                            PopulateElementMonitorDropParticipant.this.setHints(item.getHintContext());
                            return Collections.singletonList(item);
                        }
                    });
                    for (ElementClassDragItem item : items) {
                        dp.add((Object)item);
                    }
                    dp.getHints().setHint(DnDHints.KEY_DND_GRID_COLUMNS, (Object)1);
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        dtde.acceptDrag(1);
    }

    public void setHints(IHintContext context) {
    }
}

