/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.IsLinkedTo;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.diagram.ui.ElementClassTransferable;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDragItem;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.modelBrowser.model.Parameter;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.utils.datastructures.Callback;

public class PopulateElementDropParticipant
extends AbstractDiagramParticipant
implements IDropTargetParticipant {
    protected GraphToDiagramSynchronizer synchronizer;

    public PopulateElementDropParticipant(GraphToDiagramSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public void dragEnter(DropTargetDragEvent dtde, IDnDContext dp) {
        if (this.diagram == null) {
            return;
        }
        Transferable tr = dtde.getTransferable();
        if (tr.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
            IStructuredSelection sel;
            Object obj = null;
            try {
                obj = tr.getTransferData(LocalObjectTransferable.FLAVOR);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!(obj instanceof IStructuredSelection)) {
                obj = LocalObjectTransfer.getTransfer().getObject();
            }
            if (obj instanceof IStructuredSelection && !(sel = (IStructuredSelection)obj).isEmpty()) {
                for (Object elm : sel.toList()) {
                    if (!(elm instanceof IAdaptable)) continue;
                    ElementClass ec = (ElementClass)((IAdaptable)elm).getAdapter(ElementClass.class);
                    if (ec != null) {
                        dp.add((Object)new ElementClassDragItem(ec));
                        continue;
                    }
                    Parameter param = (Parameter)((IAdaptable)elm).getAdapter(Parameter.class);
                    if (param != null) {
                        dp.add((Object)new ElementClassDragItem(this.synchronizer.getElementClassProvider().get(ElementClasses.FLAG)));
                        continue;
                    }
                    Resource r = (Resource)((IAdaptable)elm).getAdapter(Resource.class);
                    if (r == null) continue;
                    boolean cfr_ignored_0 = elm instanceof ISymbolItem;
                    try {
                        String valid = this.validateDrop((RequestProcessor)this.synchronizer.getSession(), r, (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE));
                        if (valid != null) continue;
                        ElementClassDragItem item = new ElementClassDragItem(this.synchronizer.getNodeClass(r));
                        item.getHintContext().setHint(ElementHints.KEY_TRANSFORM, (Object)AffineTransform.getScaleInstance(1.0, 1.0));
                        dp.add((Object)item);
                    }
                    catch (DatabaseException valid) {
                        // empty catch block
                    }
                }
                dp.getHints().removeHint(DnDHints.KEY_DND_GRID_COLUMNS);
            }
            return;
        }
        if (tr.isDataFlavorSupported(ElementClassTransferable.FLAVOR)) {
            ElementClassTransferable.ResourceElementClassTransferData dada;
            try {
                dada = (ElementClassTransferable.ResourceElementClassTransferData)tr.getTransferData(ElementClassTransferable.FLAVOR);
            }
            catch (UnsupportedFlavorException e) {
                throw new Error(e);
            }
            catch (IOException e) {
                throw new Error(e);
            }
            Session s = this.synchronizer.getSession();
            try {
                String[] stringArray = dada.elementClassResourceRandomAccessReference;
                int n = dada.elementClassResourceRandomAccessReference.length;
                int n2 = 0;
                while (n2 < n) {
                    String rid = stringArray[n2];
                    SerialisationSupport support = (SerialisationSupport)s.getService(SerialisationSupport.class);
                    Resource r = support.getResource(Long.parseLong(rid));
                    dp.add((Object)new ElementClassDragItem(this.synchronizer.getNodeClass(r)));
                    ++n2;
                }
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    private String validateDrop(RequestProcessor processor, final Resource draggedResource, final Resource dropTarget) throws DatabaseException {
        return (String)processor.syncRequest((Read)new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Resource componentTypeFromDiagram;
                Resource componentTypeFromDiagram2;
                Resource sourceModel = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(draggedResource));
                Resource targetModel = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(dropTarget));
                if (sourceModel != null && !((Boolean)graph.syncRequest((Read)new IsLinkedTo(targetModel, sourceModel))).booleanValue()) {
                    return "Cannot instantiate " + NameUtils.getSafeName((ReadGraph)graph, (Resource)draggedResource) + " into model " + NameUtils.getSafeName((ReadGraph)graph, (Resource)targetModel) + ". The source is in another model (" + NameUtils.getSafeName((ReadGraph)graph, (Resource)sourceModel) + ").";
                }
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                Resource configuration = graph.getPossibleObject(dropTarget, MOD.DiagramToComposite);
                if (configuration != null && (componentTypeFromDiagram2 = graph.getPossibleObject(configuration, STR.Defines)) != null && Layer0Utils.isPublished((ReadGraph)graph, (Resource)componentTypeFromDiagram2)) {
                    return "Cannot create elements into a diagram that belongs to a published user component.";
                }
                Resource componentTypeFromSymbol = graph.getPossibleObject(draggedResource, MOD.SymbolToComponentType);
                if (componentTypeFromSymbol != null && configuration != null && (componentTypeFromDiagram = graph.getPossibleObject(configuration, STR.Defines)) != null && componentTypeFromSymbol.equals(componentTypeFromDiagram)) {
                    return "Cannot instantiate user component within its own configuration.";
                }
                return null;
            }
        });
    }

    public void dragExit(DropTargetEvent dte, IDnDContext dp) {
    }

    public void dragOver(DropTargetDragEvent dtde, IDnDContext dp) {
    }

    public void drop(DropTargetDropEvent dtde, final IDnDContext dp) {
        IDiagram d = (IDiagram)this.getHint(DiagramHints.KEY_DIAGRAM);
        if (d == null) {
            return;
        }
        DiagramUtils.mutateDiagram((IDiagram)d, (Callback)new Callback<DiagramMutator>(){

            public void run(DiagramMutator m) {
                IDragItem[] items;
                IDragItem[] iDragItemArray = items = (IDragItem[])dp.toArray();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IDragItem i = iDragItemArray[n2];
                    if (i instanceof ElementClassDragItem) {
                        ElementClassDragItem res = (ElementClassDragItem)i;
                        ElementClass ec = res.getElementClass();
                        Point2D pos = dp.getItemPosition(i);
                        if (!$assertionsDisabled && pos == null) {
                            throw new AssertionError();
                        }
                        IElement element = m.newElement(ec);
                        element.setHints(res.getHintContext().getHints());
                        PopulateElementDropParticipant.this.setupDroppedElement(element, pos);
                        dp.remove((Object)i);
                    }
                    ++n2;
                }
            }
        });
        this.getContext().getContentContext().setDirty();
    }

    protected void setupDroppedElement(IElement element, Point2D dropPos) {
        IElement parent;
        ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getContext().getHintStack().getHint(DiagramHints.SNAP_ADVISOR);
        if (snapAdvisor != null) {
            snapAdvisor.snap(dropPos);
        }
        if ((parent = (IElement)element.getHint(ElementHints.KEY_PARENT_ELEMENT)) != null) {
            Point2D parentPos = ElementUtils.getPos((IElement)parent);
            Point2D.Double pos = new Point2D.Double(dropPos.getX() - parentPos.getX(), dropPos.getY() - parentPos.getY());
            ElementUtils.setPos((IElement)element, (Point2D)pos);
        } else {
            ElementUtils.setPos((IElement)element, (Point2D)dropPos);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde, IDnDContext dp) {
        dtde.acceptDrag(1);
    }

    public int getAllowedOps() {
        return 1;
    }
}

