/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.OpenDiagramFromConfigurationAdapter;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;

public class OpenDiagramFromIssue
extends AbstractResourceEditorAdapter {
    private static final String EDITOR_ID = "org.simantics.modeling.ui.plainDiagramEditor";

    public OpenDiagramFromIssue() {
        super("Open Diagram Containing Referenced Element", Activator.COMPOSITE_ICON);
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        return OpenDiagramFromIssue.findElement(g, r) != null;
    }

    public void openEditor(final Resource r) throws Exception {
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
                Resource element = OpenDiagramFromIssue.findElement(g, r);
                if (element == null) {
                    return;
                }
                System.err.println("element " + g.getURI(element));
                Resource diagram = g.getSingleObject(element, L0.PartOf);
                Resource composite = g.getSingleObject(diagram, MOD.DiagramToComposite);
                OpenDiagramFromConfigurationAdapter.openEditor(g, composite, OpenDiagramFromIssue.this.getEditorId(), Collections.singleton(element));
            }
        });
    }

    private static Resource findConfigurationForElement(ReadGraph graph, Resource element) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource diagram = graph.getPossibleObject(element, L0.PartOf);
        if (diagram == null) {
            return null;
        }
        return graph.getPossibleObject(diagram, MOD.DiagramToComposite);
    }

    private static Resource findElement(ReadGraph graph, Resource issue) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(issue, ISSUE.Issue)) {
            return null;
        }
        Resource list = graph.getSingleObject(issue, ISSUE.Issue_HasContexts);
        for (Resource context : ListUtils.toList((ReadGraph)graph, (Resource)list)) {
            if (!graph.isInstanceOf(context, DIA.Element) || graph.isInstanceOf(context, DIA.Diagram)) continue;
            return context;
        }
        return null;
    }

    public static Collection<Object> findElementObjects(ReadGraph g, Resource module) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (Resource element : g.getObjects(module, MOD.ComponentToElement)) {
            if (g.isInstanceOf(element, DIA.Flag) && FlagUtil.isExternal((ReadGraph)g, (Resource)element)) {
                selectedObjects.clear();
                selectedObjects.add(element);
                break;
            }
            if (g.isInstanceOf(element, DIA.RouteGraphConnection)) {
                selectedObjects.add(element);
                continue;
            }
            if (g.isInstanceOf(element, DIA.Connection)) {
                ConnectionUtil cu = new ConnectionUtil(g);
                cu.gatherConnectionParts(element, selectedObjects);
                continue;
            }
            selectedObjects.add(element);
        }
        for (Resource element : g.getObjects(module, MOD.HasParentComponent_Inverse)) {
            selectedObjects.add(element);
        }
        return selectedObjects;
    }
}

