/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.browsing.ui.SelectionDataResolver;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.EvaluatorDataImpl;
import org.simantics.browsing.ui.common.processors.ComparableFactoryResolver;
import org.simantics.browsing.ui.common.processors.ComparableSelectorQueryProcessor;
import org.simantics.browsing.ui.common.processors.ImageDecoratorFactoryResolver;
import org.simantics.browsing.ui.common.processors.ImagerFactoryResolver;
import org.simantics.browsing.ui.common.processors.LabelDecoratorFactoryResolver;
import org.simantics.browsing.ui.common.processors.LabelerFactoryResolver;
import org.simantics.browsing.ui.common.processors.UserSelectedComparableFactoryQueryProcessor;
import org.simantics.browsing.ui.common.processors.UserSelectedViewpointFactoryQueryProcessor;
import org.simantics.browsing.ui.common.processors.ViewpointFactoryResolver;
import org.simantics.browsing.ui.graph.impl.AsyncReadGraphDataSource;
import org.simantics.browsing.ui.graph.impl.InheritsQueryProcessor;
import org.simantics.browsing.ui.graph.impl.ReadGraphDataSource;
import org.simantics.browsing.ui.graph.impl.RelatedObjectsQueryProcessor;
import org.simantics.browsing.ui.swt.ContextMenuInitializer;
import org.simantics.browsing.ui.swt.DefaultKeyListener;
import org.simantics.browsing.ui.swt.DefaultMouseListener;
import org.simantics.browsing.ui.swt.DefaultSelectionDataResolver;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.browsing.ui.swt.TypesQueryProcessor;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.modelBrowser.ModelEvaluators;
import org.simantics.modeling.ui.modelBrowser.model.INode;
import org.simantics.modeling.ui.modelBrowser.model.INode2;
import org.simantics.structural.ui.menuContributions.LinkWithEditorContribution;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.utils.datastructures.Function;
import org.simantics.utils.datastructures.Functions;

public class DiagramOutlinePage
extends Page
implements IContentOutlinePage,
IPostSelectionProvider {
    ISessionContextProvider sessionContextProvider;
    IResourceEditorInput2 input;
    LocalResourceManager resourceManager;
    Composite composite;
    GraphExplorer explorer;
    LinkWithEditor linkWithEditor;

    DiagramOutlinePage(ISessionContextProvider contextProvider, IResourceEditorInput2 input) {
        assert (contextProvider != null);
        assert (input != null);
        this.sessionContextProvider = contextProvider;
        this.input = input;
    }

    public void createControl(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.composite);
        this.explorer = GraphExplorerFactory.getInstance().selectionDataResolver((SelectionDataResolver)new DefaultSelectionDataResolver()).create(this.composite);
        Control control = (Control)this.explorer.getControl();
        ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
        new ContextMenuInitializer("#GraphExplorerPopup").createContextMenu(control, selectionProvider, (IWorkbenchSite)this.getSite());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        Function resolver = Functions.constant((Object[])new String[]{"single"});
        this.explorer.addListener((Object)new DefaultKeyListener(this.sessionContextProvider, this.explorer, resolver));
        this.explorer.addListener((Object)new DefaultMouseListener(this.explorer));
        ISessionContext sessionContext = this.sessionContextProvider.getSessionContext();
        Session session = sessionContext != null ? sessionContext.getSession() : null;
        EvaluatorData data = null;
        if (session != null) {
            data = this.createEvaluatorData(sessionContext);
            this.explorer.setDataSource((DataSource)new AsyncReadGraphDataSource((AsyncRequestProcessor)session));
            this.explorer.setDataSource((DataSource)new ReadGraphDataSource((AsyncRequestProcessor)session));
        } else {
            data = new EvaluatorDataImpl();
            this.explorer.removeDataSource(AsyncReadGraph.class);
            this.explorer.removeDataSource(ReadGraph.class);
        }
        this.explorer.setProcessor((NodeQueryProcessor)new ComparableFactoryResolver(data));
        this.explorer.setProcessor((NodeQueryProcessor)new ViewpointFactoryResolver(data));
        this.explorer.setProcessor((NodeQueryProcessor)new LabelerFactoryResolver(data));
        this.explorer.setProcessor((NodeQueryProcessor)new ImagerFactoryResolver(data));
        this.explorer.setProcessor((NodeQueryProcessor)new LabelDecoratorFactoryResolver(data));
        this.explorer.setProcessor((NodeQueryProcessor)new ImageDecoratorFactoryResolver(data));
        this.explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new TypesQueryProcessor());
        this.explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new InheritsQueryProcessor());
        this.explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new RelatedObjectsQueryProcessor());
        this.explorer.setProcessor((NodeQueryProcessor)new ComparableSelectorQueryProcessor());
        this.explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new UserSelectedViewpointFactoryQueryProcessor());
        this.explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new UserSelectedComparableFactoryQueryProcessor());
        try {
            Object finalInput;
            final Resource diagram = this.input.getResource();
            if (diagram != null && session != null && (finalInput = session.syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                    return graph.getPossibleObject(diagram, mr.DiagramToComposite);
                }
            })) != null) {
                this.explorer.setRoot(finalInput);
            }
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.dispose();
    }

    protected EvaluatorData createEvaluatorData(ISessionContext sessionContext) {
        EvaluatorDataImpl data = new EvaluatorDataImpl();
        data.addEvaluator(Resource.class, ModelEvaluators.createResourceEvaluator());
        data.addEvaluator(INode.class, ModelEvaluators.createNodeEvaluator());
        data.addEvaluator(INode2.class, ModelEvaluators.createNode2Evaluator());
        return data;
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        this.explorer.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)this.explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)this.explorer.getAdapter(IPostSelectionProvider.class);
        return selectionProvider.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)this.explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)this.explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.setSelection(selection);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)this.explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.addPostSelectionChangedListener(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)this.explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.removePostSelectionChangedListener(listener);
    }

    static class LinkWithEditor
    extends LinkWithEditorContribution {
        public LinkWithEditor() {
            super("DiagramOutlinePage.linkWithEditor", Activator.getDefault().getPreferenceStore());
        }
    }
}

