/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.style;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.issues.Severity;
import org.simantics.issues.common.IssueResourcesContexts;
import org.simantics.issues.common.ListModelIssuesBySeverity;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagram.style.IssueResult;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.Decoration;
import org.simantics.scenegraph.g2d.nodes.DecorationSVGNode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;

public class IssueDecorationStyle
extends StyleBase<IssueResult> {
    private static final String DECORATION_NODE_NAME = "issueDecorations";

    private Set<Resource> getContexts(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        HashSet<Resource> result = new HashSet<Resource>(4);
        result.add(element);
        Resource config = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (config != null) {
            result.add(config);
        }
        if ((config = graph.getPossibleObject(element, MOD.DiagramConnectionToConnection)) != null) {
            result.add(config);
        }
        if ((config = graph.getPossibleObject(element, MOD.HasParentComponent)) != null) {
            result.add(config);
        }
        return result;
    }

    public IssueResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        Resource model = Variables.getModel((ReadGraph)graph, (Variable)configuration);
        if (model == null) {
            return null;
        }
        Set<Resource> contexts = this.getContexts(graph, element);
        AffineTransform transform = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
        Map issuesBySeverity = (Map)graph.syncRequest((Read)new ListModelIssuesBySeverity(model, true, true, Severity.NOTE), (Listener)TransientCacheListener.instance());
        Severity[] severityArray = Severity.values();
        int n = severityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Set issueContexts;
            Severity severity = severityArray[n2];
            List issues = (List)issuesBySeverity.get(severity);
            if (issues != null && !Collections.disjoint(issueContexts = (Set)graph.syncRequest((Read)new IssueResourcesContexts((Collection)issues)), contexts)) {
                return new IssueResult(severity, transform);
            }
            ++n2;
        }
        return null;
    }

    public void applyStyleForNode(EvaluationContext observer, INode node, IssueResult result) {
        if (result == null) {
            ProfileVariables.denyChild((INode)node, (String)"", (String)DECORATION_NODE_NAME);
            return;
        }
        SVGNode svgNode = (SVGNode)ProfileVariables.claimChild((INode)node, (String)"", (String)DECORATION_NODE_NAME, DecorationSVGNode.class, (Observer)observer);
        Rectangle2D bounds = NodeUtil.getLocalBounds((INode)node, Decoration.class);
        double tx = bounds.getX();
        double ty = bounds.getY();
        svgNode.setZIndex(Integer.MAX_VALUE);
        svgNode.setTransform(AffineTransform.getTranslateInstance(tx, ty));
        String svgData = this.svgDataForSeverity(result.getSeverity());
        if (svgData != null) {
            svgNode.setData(svgData);
        }
    }

    private String svgDataForSeverity(Severity s) {
        switch (s) {
            case FATAL: {
                return Activator.FATAL_SVG_TEXT;
            }
            case ERROR: {
                return Activator.ERROR_SVG_TEXT;
            }
            case WARNING: {
                return Activator.WARNING_SVG_TEXT;
            }
            case INFO: {
                return Activator.INFO_SVG_TEXT;
            }
            case NOTE: {
                return Activator.NOTE_SVG_TEXT;
            }
        }
        return null;
    }

    protected void cleanupStyleForNode(INode node) {
        ProfileVariables.denyChild((INode)node, (String)"", (String)DECORATION_NODE_NAME);
    }

    public String toString() {
        return "Issue decoration";
    }
}

