/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.renaming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.Configuration;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.services.ComponentNamingStrategy;
import org.simantics.modeling.services.ComponentNamingUtil;
import org.simantics.modeling.services.NamingException;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagram.renaming.NameEntry;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural.stubs.StructuralResource2;

public class ComponentsRenamingModel {
    public ArrayList<NameEntry> entries = new ArrayList();
    public String oldNamePrefix;
    public String newNamePrefix;
    public boolean reset;
    public Function1<String, String> prefixValidator;
    private Session session;
    private Variable compositeVariable;
    private Resource configuration;
    private ComponentNamingStrategy namingStrategy;

    public void read(ReadGraph g, Resource composite) throws DatabaseException {
        this.session = g.getSession();
        this.compositeVariable = Variables.getVariable((ReadGraph)g, (Resource)composite);
        this.configuration = (Resource)g.syncRequest((Read)new Configuration(composite));
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        for (Resource component : g.getObjects(composite, L0.ConsistsOf)) {
            if (!g.isInstanceOf(component, STR.Component)) continue;
            String name = (String)g.getRelatedValue(component, L0.HasName);
            Resource componentType = g.getPossibleType(component, STR.Component);
            String componentTypePrefix = componentType != null ? (String)g.getPossibleRelatedValue(componentType, L0X.HasGeneratedNamePrefix, (Binding)Bindings.STRING) : "";
            this.entries.add(new NameEntry(component, name, name, componentTypePrefix));
        }
        Collections.sort(this.entries);
        Variable namePrefixValue = this.compositeVariable.getProperty(g, L0X.HasGeneratedNamePrefix);
        this.oldNamePrefix = this.newNamePrefix = (String)namePrefixValue.getValue(g, (Binding)Bindings.STRING);
        Variable displayValue = namePrefixValue.getPossibleProperty(g, "HasDisplayValue");
        if (displayValue != null) {
            this.prefixValidator = (Function1)displayValue.getPossiblePropertyValue(g, "HasInputValidator");
        }
        this.namingStrategy = ComponentNamingUtil.findNamingStrategy((ReadGraph)g, null, (Resource)composite);
    }

    public void computeNewNames() {
        final boolean reset = this.reset;
        if (reset) {
            for (NameEntry entry : this.entries) {
                entry.newName = String.valueOf(this.newNamePrefix) + entry.namingPrefix;
            }
        } else {
            for (NameEntry entry : this.entries) {
                if (!entry.oldName.startsWith(this.oldNamePrefix)) continue;
                entry.newName = String.valueOf(this.newNamePrefix) + entry.oldName.substring(this.oldNamePrefix.length());
            }
        }
        if (this.session != null) {
            try {
                this.session.syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        ComponentsRenamingModel.this.validateNewNames(graph, !reset);
                    }
                });
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "validateNewNames failed, see exception for details", (Throwable)e));
            }
        } else if (reset) {
            int i = 0;
            for (NameEntry entry : this.entries) {
                entry.newName = String.valueOf(entry.newName) + ++i;
            }
        }
    }

    private void validateNewNames(ReadGraph graph, boolean acceptPropositions) throws DatabaseException {
        try {
            if (this.namingStrategy != null) {
                List propositions = new ArrayList<String>(this.entries.size());
                for (NameEntry entry : this.entries) {
                    propositions.add(entry.newName);
                }
                propositions = this.namingStrategy.validateInstanceNames(graph, this.configuration, propositions, acceptPropositions, null);
                int i = 0;
                while (i < propositions.size()) {
                    NameEntry entry = this.entries.get(i);
                    if (!acceptPropositions || !entry.oldName.equals(entry.newName)) {
                        entry.newName = (String)propositions.get(i);
                    }
                    ++i;
                }
            }
        }
        catch (NamingException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void write(WriteGraph g) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
        for (NameEntry entry : this.entries) {
            if (entry.oldName.equals(entry.newName)) continue;
            g.claimLiteral(entry.resource, L0.HasName, (Object)entry.newName, (Binding)Bindings.STRING);
        }
        if (!this.oldNamePrefix.equals(this.newNamePrefix)) {
            this.compositeVariable.setPropertyValue(g, L0X.HasGeneratedNamePrefix, (Object)this.newNamePrefix, (Binding)Bindings.STRING);
        }
    }
}

