/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.renaming;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.modeling.ui.diagram.renaming.ComponentsRenamingModel;
import org.simantics.modeling.ui.diagram.renaming.NameEntry;

public class ComponentsRenamingDialog
extends Dialog {
    ComponentsRenamingModel model;
    Composite area;
    Label oldNamePrefixLabel;
    Text oldNamePrefix;
    Text newNamePrefix;
    Label errorLabel;
    Text error;
    TableViewer tableViewer;

    public ComponentsRenamingDialog(Shell parentShell, ComponentsRenamingModel model) {
        super(parentShell);
        this.model = model;
        this.setShellStyle(48);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Rename diagram contents");
        this.getShell().setLayout((Layout)new GridLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.area = new Composite(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.area);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(this.area);
        this.oldNamePrefixLabel = new Label(this.area, 0);
        this.oldNamePrefixLabel.setText("Old name prefix:");
        this.oldNamePrefix = new Text(this.area, 2056);
        this.oldNamePrefix.setEditable(false);
        this.oldNamePrefix.setText(this.model.oldNamePrefix);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.oldNamePrefix);
        Label newNamePrefixLabel = new Label(this.area, 0);
        newNamePrefixLabel.setText("&New name prefix:");
        this.newNamePrefix = new Text(this.area, 2048);
        this.newNamePrefix.setText(this.model.oldNamePrefix);
        this.newNamePrefix.setSelection(this.model.oldNamePrefix.length());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.newNamePrefix);
        this.newNamePrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ComponentsRenamingDialog.this.newNamePrefix.getText();
                if (ComponentsRenamingDialog.this.model.prefixValidator != null) {
                    String err = (String)ComponentsRenamingDialog.this.model.prefixValidator.apply((Object)text);
                    if (err != null) {
                        if (ComponentsRenamingDialog.this.error == null) {
                            ComponentsRenamingDialog.this.errorLabel = new Label(ComponentsRenamingDialog.this.area, 0);
                            ComponentsRenamingDialog.this.errorLabel.moveBelow((Control)ComponentsRenamingDialog.this.newNamePrefix);
                            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)ComponentsRenamingDialog.this.errorLabel);
                            ComponentsRenamingDialog.this.error = new Text(ComponentsRenamingDialog.this.area, 74);
                            ComponentsRenamingDialog.this.error.moveBelow((Control)ComponentsRenamingDialog.this.errorLabel);
                            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)ComponentsRenamingDialog.this.error);
                            ComponentsRenamingDialog.this.error.setForeground(ComponentsRenamingDialog.this.error.getDisplay().getSystemColor(3));
                        }
                        ComponentsRenamingDialog.this.error.setText(err);
                        ComponentsRenamingDialog.this.area.getParent().layout();
                        ComponentsRenamingDialog.this.getButton(0).setEnabled(false);
                        return;
                    }
                    if (ComponentsRenamingDialog.this.error != null) {
                        ComponentsRenamingDialog.this.errorLabel.dispose();
                        ComponentsRenamingDialog.this.errorLabel = null;
                        ComponentsRenamingDialog.this.error.dispose();
                        ComponentsRenamingDialog.this.error = null;
                        ComponentsRenamingDialog.this.area.getParent().layout();
                        ComponentsRenamingDialog.this.getButton(0).setEnabled(true);
                    }
                }
                ComponentsRenamingDialog.this.model.newNamePrefix = text;
                ComponentsRenamingDialog.this.model.computeNewNames();
                ComponentsRenamingDialog.this.refresh();
            }
        });
        final Button resetNames = new Button(composite, 32);
        resetNames.setText("&Reset names");
        resetNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentsRenamingDialog.this.model.reset = resetNames.getSelection();
                ComponentsRenamingDialog.this.model.computeNewNames();
                ComponentsRenamingDialog.this.refresh();
            }
        });
        this.tableViewer = new TableViewer(composite);
        this.tableViewer.getTable().setHeaderVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tableViewer.getTable());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn oldNameColumn = new TableViewerColumn(this.tableViewer, 0);
        oldNameColumn.getColumn().setText("Old name");
        oldNameColumn.getColumn().setWidth(250);
        oldNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NameEntry entry = (NameEntry)element;
                return entry.oldName;
            }
        });
        TableViewerColumn newNameColumn = new TableViewerColumn(this.tableViewer, 0);
        newNameColumn.getColumn().setText("New name");
        newNameColumn.getColumn().setWidth(250);
        newNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NameEntry entry = (NameEntry)element;
                return entry.newName;
            }
        });
        this.tableViewer.setInput((Object)this.model.entries.toArray());
        this.newNamePrefix.setFocus();
        return composite;
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.open();
        ComponentsRenamingModel model = new ComponentsRenamingModel();
        model.oldNamePrefix = "FOO";
        model.newNamePrefix = "FOO";
        int i = 0;
        while (i < 100) {
            model.entries.add(new NameEntry(null, "FOO" + i * 5, "FOO" + i * 5, "PREFIX"));
            ++i;
        }
        ComponentsRenamingDialog dialog = new ComponentsRenamingDialog(shell, model);
        dialog.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

