/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.monitor;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;

public class RealizedFormatterAdapter
extends SimpleContextualAdapter<Formatter, RelationContext> {
    public Formatter adapt(ReadGraph graph, Resource source, RelationContext context) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource formatter = context.getStatement().getObject();
        String definition = (String)graph.getRelatedValue(formatter, DIA.RealizedFormatter_HasDefinition, (Binding)Bindings.STRING);
        final String label = (String)graph.getPossibleRelatedAdapter(formatter, L0.HasLabel, String.class);
        final DecimalFormat format = new DecimalFormat(definition, DecimalFormatSymbols.getInstance(Locale.US));
        return new Formatter(){

            private String formatNumber(Number v) {
                double dv = v.doubleValue();
                if (Double.isInfinite(dv)) {
                    return dv == Double.POSITIVE_INFINITY ? "\u221e" : "-\u221e";
                }
                if (Double.isNaN(dv)) {
                    return "NaN";
                }
                return format.format(v);
            }

            public String format(Object object) {
                if (object instanceof Number) {
                    Number num = (Number)object;
                    return this.formatNumber(num);
                }
                if (object instanceof String) {
                    try {
                        Double d = Double.parseDouble((String)object);
                        return this.formatNumber(d);
                    }
                    catch (NumberFormatException e) {
                        return (String)object;
                    }
                }
                return object != null ? object.toString() : "";
            }

            public String toString() {
                return label;
            }
        };
    }
}

