/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.monitor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.simantics.basicexpression.analysis.DepthFirstAdapter;
import org.simantics.basicexpression.analysis.EvaluationException;
import org.simantics.basicexpression.node.AAddressValue;
import org.simantics.basicexpression.node.AConstantValue;
import org.simantics.basicexpression.node.AFunctionPrimary;
import org.simantics.basicexpression.node.AMultMultiplicative;
import org.simantics.basicexpression.node.APlusExpression;
import org.simantics.basicexpression.node.ARangeValue;
import org.simantics.basicexpression.node.ARviValue;
import org.simantics.basicexpression.node.ASequenceArgList;
import org.simantics.basicexpression.node.ASingleArgList;
import org.simantics.basicexpression.node.ASingleRange;
import org.simantics.basicexpression.node.AStringValue;
import org.simantics.basicexpression.node.AVariablePrimary;
import org.simantics.basicexpression.node.PArgList;
import org.simantics.common.format.Formatter;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ModelInstances;
import org.simantics.db.layer0.request.VariableIndexRoot;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function;

public class MonitorExpressionVisitor
extends DepthFirstAdapter {
    public static final boolean DEBUG_APPLICATION = false;
    public static final boolean DEBUG = false;
    final ReadGraph graph;
    final Variable variable;
    final Formatter formatter;
    Stack<Object> stack = new Stack();
    HashMap<String, Function> builtins = new HashMap();

    public MonitorExpressionVisitor(ReadGraph graph, Formatter formatter, Variable variable) {
        this.graph = graph;
        this.formatter = formatter;
        this.variable = variable;
    }

    public Object getResult() {
        if (this.exception != null) {
            return this.exception;
        }
        return this.stack.pop();
    }

    public void outAConstantValue(AConstantValue node) {
        this.stack.push(Double.valueOf(node.toString()));
    }

    public void outAStringValue(AStringValue node) {
        String value = node.toString();
        this.stack.push(value.substring(1, value.length() - 2));
    }

    public void outAAddressValue(AAddressValue node) {
        this.stack.push(String.valueOf('&') + node.getRange().toString());
    }

    public void outASingleRange(ASingleRange node) {
    }

    public void outARviValue(ARviValue node) {
        String rvi = node.toString().trim();
        try {
            Variable var = this.variable.browse(this.graph, rvi);
            this.stack.push(this.format(var.getValue(this.graph)));
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            this.stack.push("<No value for '" + rvi + "'>");
        }
    }

    public void outAVariablePrimary(AVariablePrimary node) {
        String identifier = node.toString().trim();
        if ("value".equals(identifier)) {
            try {
                this.stack.push(this.format(this.variable.getValue(this.graph)));
            }
            catch (DatabaseException e) {
                this.stack.push((Object)e);
            }
        } else {
            this.stack.push(identifier);
        }
    }

    public void outARangeValue(ARangeValue node) {
        String identifier = node.getRange().toString().trim();
        this.stack.push(identifier);
    }

    private String format(Object o) {
        if (this.formatter != null) {
            return this.formatter.format(o);
        }
        return o != null ? o.toString() : "";
    }

    private double extractValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.valueOf((String)o);
        }
        return Double.NaN;
    }

    private Object extractSum(Object o1, Object o2) {
        if (o1 instanceof String) {
            return String.valueOf(o1.toString()) + o2;
        }
        if (o2 instanceof String) {
            return String.valueOf(o1.toString()) + o2.toString();
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return ((Number)o1).doubleValue() + ((Number)o2).doubleValue();
        }
        return String.valueOf(o1.toString()) + o2.toString();
    }

    public void outAPlusExpression(APlusExpression node) {
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        Object out = this.extractSum(o1, o2);
        this.stack.push(out);
    }

    public void outAMultMultiplicative(AMultMultiplicative node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        double d1 = this.extractValue(o1);
        double d2 = this.extractValue(o2);
        this.stack.push(d1 * d2);
    }

    int countArguments(PArgList args) {
        if (args == null) {
            return 0;
        }
        if (args instanceof ASingleArgList) {
            return 1;
        }
        ASequenceArgList seq = (ASequenceArgList)args;
        return 1 + this.countArguments(seq.getArgList());
    }

    public void outAFunctionPrimary(AFunctionPrimary node) {
        block7: {
            try {
                String functionName = node.getFunc().getText().replace("(", "");
                Function function = this.builtins.get(functionName);
                if (function != null) {
                    LinkedList<Object> args = new LinkedList<Object>();
                    int argc = this.countArguments(node.getArgList());
                    int i = 0;
                    while (i < argc) {
                        args.addFirst(this.stack.pop());
                        ++i;
                    }
                    args.addFirst(this.formatter);
                    args.addFirst(this.variable);
                    args.addFirst(this.graph);
                    Object result = function.applyArray(new Object[]{args});
                    this.stack.push(this.format(result));
                    break block7;
                }
                Layer0 L0 = Layer0.getInstance((ReadGraph)this.graph);
                Resource functionResource = null;
                Resource indexRoot = (Resource)this.graph.sync((ReadInterface)new VariableIndexRoot(this.variable));
                if (indexRoot != null) {
                    Map functions = (Map)this.graph.syncRequest((Read)new ModelInstances(indexRoot, L0.Function), (Listener)TransientCacheListener.instance());
                    functionResource = (Resource)functions.get(functionName);
                }
                if (functionResource != null) {
                    function = (Function)this.graph.adapt(functionResource, Function.class);
                    LinkedList<Object> args = new LinkedList<Object>();
                    int argc = this.countArguments(node.getArgList());
                    int i = 0;
                    while (i < argc) {
                        args.addFirst(this.stack.pop());
                        ++i;
                    }
                    args.addFirst(this.formatter);
                    args.addFirst(this.variable);
                    args.addFirst(this.graph);
                    Object result = function.applyArray(args.toArray());
                    this.stack.push(this.format(result));
                    break block7;
                }
                throw new EvaluationException("Function not found in dependencies: '" + functionName + "'");
            }
            catch (DatabaseException e) {
                this.stack.push(null);
            }
        }
    }

    public static class ApplicationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ApplicationException(String message) {
            super(message);
        }
    }
}

