/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.modeling.ui.diagram.PageDescComposite;
import org.simantics.modeling.ui.preferences.DiagramPreferences;
import org.simantics.scl.commands.Commands;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.page.PageDesc;

public class PageSettingsDialog
extends Dialog {
    private final Session session = SimanticsUI.getSession();
    private final Resource diagramResource;
    private PageDescComposite pdc;
    private Text gridSizeText;
    private Button showBordersButton;
    private Button showMarginsButton;
    private PageDesc pageDesc;
    private double gridSize;
    private double lastGridSize;
    private boolean borders = false;
    private boolean margins = false;

    public PageSettingsDialog(Resource diagramResource, Shell parentShell) {
        super(parentShell);
        this.diagramResource = diagramResource;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Page Settings");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Group group = new Group(composite, 0);
        group.setText("Grid Snapping");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)group);
        Label label = new Label((Composite)group, 0);
        label.setText("Grid size (mm)");
        this.gridSizeText = new Text((Composite)group, 2052);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)group);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.gridSizeText);
        Group pageGroup = new Group(composite, 0);
        pageGroup.setText("Page size");
        this.pdc = new PageDescComposite((Composite)pageGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)pageGroup);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)pageGroup);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)this.pdc);
        Group displayGroup = new Group(composite, 0);
        displayGroup.setText("Display");
        this.showBordersButton = new Button((Composite)displayGroup, 32);
        this.showBordersButton.setText("Show page borders");
        this.showMarginsButton = new Button((Composite)displayGroup, 32);
        this.showMarginsButton.setText("Show margins");
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).extendedMargins(12, 12, 12, 12).spacing(5, 4).applyTo((Composite)displayGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)displayGroup);
        this.gridSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                try {
                    PageSettingsDialog.this.gridSize = Double.parseDouble(text);
                    if (PageSettingsDialog.this.gridSize < 0.001 || PageSettingsDialog.this.gridSize > 1000.0) {
                        PageSettingsDialog.this.gridSize = PageSettingsDialog.this.lastGridSize;
                        this.setGridSizeValid(false);
                    } else {
                        this.setGridSizeValid(true);
                    }
                }
                catch (NumberFormatException err) {
                    PageSettingsDialog.this.gridSize = PageSettingsDialog.this.lastGridSize;
                    this.setGridSizeValid(false);
                }
            }

            void setGridSizeValid(boolean valid) {
                if (valid) {
                    PageSettingsDialog.this.gridSizeText.setBackground(null);
                    PageSettingsDialog.this.gridSizeText.setForeground(null);
                } else {
                    PageSettingsDialog.this.gridSizeText.setForeground(PageSettingsDialog.this.gridSizeText.getDisplay().getSystemColor(3));
                }
            }
        });
        this.showBordersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageSettingsDialog.this.borders = ((Button)e.widget).getSelection();
            }
        });
        this.showMarginsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageSettingsDialog.this.margins = ((Button)e.widget).getSelection();
            }
        });
        this.loadValues();
        return composite;
    }

    public void applySettings() {
        if (this.pdc.getPageDesc() != null) {
            this.pageDesc = this.pdc.getPageDesc();
        }
        this.session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Resource model = (Resource)graph.syncRequest((Read)new IndexRoot(PageSettingsDialog.this.diagramResource));
                Commands.get((ReadGraph)graph, (String)"Simantics/PageSettings/setPageDesc").execute((RequestProcessor)graph, model, new Object[]{PageSettingsDialog.this.diagramResource, PageSettingsDialog.this.pageDesc.toRepr()});
                Commands.get((ReadGraph)graph, (String)"Simantics/PageSettings/setGridSize").execute((RequestProcessor)graph, model, new Object[]{PageSettingsDialog.this.diagramResource, PageSettingsDialog.this.gridSize});
                Commands.get((ReadGraph)graph, (String)"Simantics/PageSettings/setPageBordersVisible").execute((RequestProcessor)graph, model, new Object[]{PageSettingsDialog.this.diagramResource, PageSettingsDialog.this.borders});
                Commands.get((ReadGraph)graph, (String)"Simantics/PageSettings/setMarginsVisible").execute((RequestProcessor)graph, model, new Object[]{PageSettingsDialog.this.diagramResource, PageSettingsDialog.this.margins});
            }
        });
    }

    private void loadValues() {
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                PageSettingsDialog.this.pageDesc = DiagramGraphUtil.getPageDesc((ReadGraph)graph, (Resource)PageSettingsDialog.this.diagramResource, (PageDesc)PageDesc.DEFAULT);
                PageSettingsDialog.this.gridSize = DiagramGraphUtil.getGridSize((ReadGraph)graph, (Resource)PageSettingsDialog.this.diagramResource, (Double)DiagramPreferences.DEFAULT_SNAP_GRID_SIZE);
                PageSettingsDialog.this.lastGridSize = PageSettingsDialog.this.gridSize;
                PageSettingsDialog.this.borders = DiagramGraphUtil.isPageBordersVisible((ReadGraph)graph, (Resource)PageSettingsDialog.this.diagramResource);
                PageSettingsDialog.this.margins = DiagramGraphUtil.isMarginsVisible((ReadGraph)graph, (Resource)PageSettingsDialog.this.diagramResource);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PageSettingsDialog.this.applyValues();
                    }
                });
            }
        });
    }

    private void applyValues() {
        this.pdc.setPageDesc(this.pageDesc);
        this.gridSizeText.setText(Double.toString(this.gridSize));
        this.showBordersButton.setSelection(this.borders);
        this.showMarginsButton.setSelection(this.margins);
    }
}

