/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.componentTypeEditor.SCLTextEditor;
import org.simantics.scl.compiler.common.errors.SCLError;
import org.simantics.structural2.scl.CompileProceduralComponentType;
import org.simantics.structural2.scl.ProceduralComponentTypeCompilationException;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.utils.datastructures.Callable;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;

public class SCLEditorBase
extends EditorPart
implements IExecutableExtension {
    Resource inputResource;
    SCLTextEditor editor;
    String originalText;

    protected TextAndErrors getTextAndErrors(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String text = (String)graph.getValue(resource, (Binding)Bindings.STRING);
        Resource componentType = graph.getPossibleObject(this.inputResource, L0.PropertyOf);
        SCLError[] errors = SCLError.EMPTY_ARRAY;
        if (componentType != null) {
            try {
                graph.syncRequest((Read)new CompileProceduralComponentType(componentType));
            }
            catch (ProceduralComponentTypeCompilationException e) {
                errors = e.errors;
            }
        }
        return new TextAndErrors(text, errors);
    }

    public void createPartControl(Composite parent) {
        this.editor = new SCLTextEditor(parent, 0);
        Simantics.getSession().asyncRequest((Read)new ResourceRead<TextAndErrors>(this.inputResource){

            public TextAndErrors perform(ReadGraph graph) throws DatabaseException {
                return SCLEditorBase.this.getTextAndErrors(graph, SCLEditorBase.this.inputResource);
            }
        }, (Listener)new Listener<TextAndErrors>(){

            public void execute(final TextAndErrors textAndErrors) {
                SWTUtils.asyncExec((Widget)SCLEditorBase.this.editor, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SCLEditorBase.this.editor.isDisposed()) {
                            return;
                        }
                        (this).SCLEditorBase.this.originalText = textAndErrors.text;
                        boolean textDiffers = !(this).SCLEditorBase.this.originalText.equals((this).SCLEditorBase.this.editor.getContent());
                        (this).SCLEditorBase.this.editor.setContent(textDiffers ? (this).SCLEditorBase.this.originalText : null, textAndErrors.errors);
                        SCLEditorBase.this.firePropertyChange(257);
                    }
                });
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }

            public boolean isDisposed() {
                return SCLEditorBase.this.editor.isDisposed();
            }
        });
        this.editor.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                SCLEditorBase.this.firePropertyChange(257);
            }
        });
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    protected void save(WriteGraph graph, Resource resource, String text) throws DatabaseException {
        graph.claimValue(resource, (Object)text);
    }

    public void doSave(IProgressMonitor monitor) {
        this.originalText = this.editor.getContent();
        this.firePropertyChange(257);
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                SCLEditorBase.this.save(graph, SCLEditorBase.this.inputResource, SCLEditorBase.this.originalText);
                Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Saved SCL Module " + graph.getRelatedValue2(SCLEditorBase.this.inputResource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)));
            }
        });
    }

    public void doSaveAs() {
    }

    protected String computeTitle(ReadGraph graph, Resource inputResource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(inputResource, L0.PropertyOf);
        if (parent == null) {
            return "No parent";
        }
        return graph.getPossibleRelatedValue(parent, L0.HasName) + " (Code)";
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.inputResource = ((IResourceEditorInput)input).getResource();
        Simantics.getSession().asyncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                return SCLEditorBase.this.computeTitle(graph, SCLEditorBase.this.inputResource);
            }
        }, (Listener)new TitleUpdater(site.getShell().getDisplay(), (Callback)new Callback<String>(){

            public void run(String partName) {
                SCLEditorBase.this.setPartName(partName);
                SCLEditorBase.this.setTitleToolTip(partName);
            }
        }, (Callable)new Callable<Boolean>(){

            public Boolean call() {
                if (SCLEditorBase.this.editor != null && SCLEditorBase.this.editor.isDisposed()) {
                    return true;
                }
                return false;
            }
        }));
    }

    public boolean isDirty() {
        return !this.editor.getContent().equals(this.originalText);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    static class TextAndErrors {
        public final String text;
        public final SCLError[] errors;

        public TextAndErrors(String text, SCLError[] errors) {
            this.text = text;
            this.errors = errors;
        }
    }
}

