/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.componentTypeEditor.SCLTextEditor;
import org.simantics.scl.compiler.common.errors.SCLError;
import org.simantics.structural2.scl.CompileProceduralComponentType;
import org.simantics.structural2.scl.ProceduralComponentTypeCompilationException;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.utils.datastructures.Callable;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;

public class ProceduralComponentTypeCodeEditor
extends EditorPart
implements IExecutableExtension {
    Resource inputResource;
    SCLTextEditor editor;
    String originalText;

    public void createPartControl(Composite parent) {
        this.editor = new SCLTextEditor(parent, 0);
        Simantics.getSession().asyncRequest((Read)new ResourceRead<TextAndErrors>(this.inputResource){

            public TextAndErrors perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                String text = (String)graph.getValue(this.resource, (Binding)Bindings.STRING);
                Resource componentType = graph.getPossibleObject(ProceduralComponentTypeCodeEditor.this.inputResource, L0.PropertyOf);
                SCLError[] errors = SCLError.EMPTY_ARRAY;
                if (componentType != null) {
                    try {
                        graph.syncRequest((Read)new CompileProceduralComponentType(componentType));
                    }
                    catch (ProceduralComponentTypeCompilationException e) {
                        errors = e.errors;
                    }
                }
                return new TextAndErrors(text, errors);
            }
        }, (Listener)new Listener<TextAndErrors>(){

            public void execute(final TextAndErrors textAndErrors) {
                SWTUtils.asyncExec((Widget)ProceduralComponentTypeCodeEditor.this.editor, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ProceduralComponentTypeCodeEditor.this.editor.isDisposed()) {
                            return;
                        }
                        (this).ProceduralComponentTypeCodeEditor.this.originalText = textAndErrors.text;
                        boolean textDiffers = !(this).ProceduralComponentTypeCodeEditor.this.originalText.equals((this).ProceduralComponentTypeCodeEditor.this.editor.getContent());
                        (this).ProceduralComponentTypeCodeEditor.this.editor.setContent(textDiffers ? (this).ProceduralComponentTypeCodeEditor.this.originalText : null, textAndErrors.errors);
                        ProceduralComponentTypeCodeEditor.this.firePropertyChange(257);
                    }
                });
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }

            public boolean isDisposed() {
                return ProceduralComponentTypeCodeEditor.this.editor.isDisposed();
            }
        });
        this.editor.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                ProceduralComponentTypeCodeEditor.this.firePropertyChange(257);
            }
        });
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        this.originalText = this.editor.getContent();
        this.firePropertyChange(257);
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.claimValue(ProceduralComponentTypeCodeEditor.this.inputResource, (Object)ProceduralComponentTypeCodeEditor.this.originalText);
            }
        });
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.inputResource = ((IResourceEditorInput)input).getResource();
        Simantics.getSession().asyncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Resource parent = graph.getPossibleObject(ProceduralComponentTypeCodeEditor.this.inputResource, L0.PropertyOf);
                if (parent == null) {
                    return "No parent";
                }
                return graph.getPossibleRelatedValue(parent, L0.HasName) + " (Code)";
            }
        }, (Listener)new TitleUpdater(site.getShell().getDisplay(), (Callback)new Callback<String>(){

            public void run(String partName) {
                ProceduralComponentTypeCodeEditor.this.setPartName(partName);
                ProceduralComponentTypeCodeEditor.this.setTitleToolTip(partName);
            }
        }, (Callable)new Callable<Boolean>(){

            public Boolean call() {
                if (ProceduralComponentTypeCodeEditor.this.editor != null && ProceduralComponentTypeCodeEditor.this.editor.isDisposed()) {
                    return true;
                }
                return false;
            }
        }));
    }

    public boolean isDirty() {
        return !this.editor.getContent().equals(this.originalText);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private static class TextAndErrors {
        public final String text;
        public final SCLError[] errors;

        public TextAndErrors(String text, SCLError[] errors) {
            this.text = text;
            this.errors = errors;
        }
    }
}

