/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.simantics.Logger;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.units.internal.library.UnitLibrary;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.RangeException;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.ModelInstances;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.XSupport;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.CompileSCLMonitorRequest;
import org.simantics.modeling.TypeMonitorContextRequest;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeCommands;
import org.simantics.modeling.ui.componentTypeEditor.SetTypesDialog;
import org.simantics.operation.Layer0X;
import org.simantics.scl.compiler.elaboration.modules.ContextModule;
import org.simantics.scl.runtime.function.Function4;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.scl.ActualCompileRequest;
import org.simantics.structural2.scl.CompilationContext;
import org.simantics.structural2.scl.SCLMainModuleRequest;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;

public class ComponentTypeViewer {
    private static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_]*");
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Type", "Default Value", "Unit", "Range", "Label", "Description"};
    private static final String[] COLUMN_NAMES2 = new String[]{"Name", "Type", "Expression", "Label", "Description"};
    private static final int[] COLUMN_LENGTHS = new int[]{120, 100, 100, 50, 100, 100, 100};
    private static final int[] COLUMN_LENGTHS2 = new int[]{120, 100, 100, 100, 100};
    private static final int[] COLUMN_WEIGHTS;
    private static final int[] COLUMN_WEIGHTS2;
    public static final String[] PROPERTY_TYPE_SUGGESTIONS;
    ResourceManager resourceManager;
    Resource componentType;
    boolean readOnly = false;
    Form form;
    Table table;
    Table table2;
    TableColumn[] columns;
    TableColumn[] columns2;
    FormToolkit tk;
    TableEditor editor;
    TableEditor editor2;
    Button newProperty;
    Button removeProperty;
    boolean hasTypes = false;
    Button setTypes;
    Button newProperty2;
    Button removeProperty2;
    UnitLibrary unitLibrary = UnitLibrary.createDefault();
    PropertyInfo[] properties;
    private static Function4<RequestProcessor, Resource, Resource, String, String> VALIDATE_MONITOR_EXPRESSION;

    static {
        int[] nArray = new int[7];
        nArray[5] = 50;
        nArray[6] = 100;
        COLUMN_WEIGHTS = nArray;
        int[] nArray2 = new int[5];
        nArray2[2] = 100;
        COLUMN_WEIGHTS2 = nArray2;
        PROPERTY_TYPE_SUGGESTIONS = new String[]{"Double", "Integer", "Float", "String", "Boolean", "Long", "[Double]", "[Integer]", "[Float]", "[String]", "[Boolean]", "[Long]", "Array Double", "Array Integer", "Array Float", "Array String", "Array Boolean", "Array Long"};
        VALIDATE_MONITOR_EXPRESSION = new Function4<RequestProcessor, Resource, Resource, String, String>(){

            public String apply(RequestProcessor p0, Resource p1, Resource p2, String p3) {
                return ComponentTypeViewer.validateMonitorExpression(p0, p1, p2, p3);
            }
        };
    }

    public ComponentTypeViewer(Composite parent, Resource _componentType, String formTitle) {
        this.componentType = _componentType;
        this.tk = new FormToolkit(parent.getDisplay());
        this.form = this.tk.createForm(parent);
        this.tk.decorateFormHeading(this.form);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.form);
        this.form.setText(formTitle);
        this.form.setImage(this.resourceManager.createImage(Activator.COMPONENT_TYPE_ICON));
        FormLayout layout = new FormLayout();
        layout.marginBottom = 10;
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        this.form.getBody().setLayout((Layout)layout);
        final Sash sash = new Sash(this.form.getBody(), 256);
        sash.setBackground(sash.getDisplay().getSystemColor(1));
        FormData data = new FormData();
        data.top = new FormAttachment(50, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 10;
        sash.setLayoutData((Object)data);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sash.setBounds(e.x, e.y, e.width, e.height);
                FormData data = new FormData();
                data.top = new FormAttachment(0, e.y);
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
                data.height = 10;
                sash.setLayoutData((Object)data);
                ComponentTypeViewer.this.form.getBody().layout(true);
            }
        });
        Section section = this.tk.createSection(this.form.getBody(), 320);
        section.setLayout((Layout)new FillLayout());
        FormData data2 = new FormData();
        data2.top = new FormAttachment(0, 0);
        data2.left = new FormAttachment(0, 0);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment((Control)sash);
        section.setLayoutData((Object)data2);
        section.setText("Configuration properties");
        Composite sectionBody = this.tk.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionBody);
        section.setClient((Control)sectionBody);
        Composite tableComposite = this.tk.createComposite(sectionBody);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tcl = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcl);
        this.table = this.tk.createTable(tableComposite, 67586);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.columns = new TableColumn[COLUMN_NAMES.length];
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            TableColumn column;
            this.columns[i] = column = new TableColumn(this.table, 0);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(COLUMN_WEIGHTS[i], COLUMN_LENGTHS[i], true));
            column.setText(COLUMN_NAMES[i]);
            ++i;
        }
        this.editor = new TableEditor(this.table);
        this.editor.grabHorizontal = true;
        this.editor.grabVertical = true;
        this.editor.horizontalAlignment = 16384;
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Control oldEditor = ComponentTypeViewer.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if (ComponentTypeViewer.this.readOnly) {
                    return;
                }
                Rectangle tableBounds = ComponentTypeViewer.this.table.getClientArea();
                int rx = e.x - tableBounds.x;
                int ry = e.y - tableBounds.y;
                TableItem selectedItem = null;
                int selectedColumn = -1;
                Rectangle selectedItemBounds = null;
                TableItem[] tableItemArray = ComponentTypeViewer.this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    int column = 0;
                    while (column < COLUMN_NAMES.length) {
                        Rectangle bounds = item.getBounds(column);
                        if (bounds.contains(rx, ry)) {
                            selectedItemBounds = bounds;
                            selectedItem = item;
                            selectedColumn = column;
                            break;
                        }
                        ++column;
                    }
                    ++n2;
                }
                if (selectedItem == null) {
                    return;
                }
                int column = selectedColumn;
                final PropertyInfo propertyInfo = (PropertyInfo)((Object)selectedItem.getData());
                final Resource resource = propertyInfo.resource;
                switch (column) {
                    case 0: {
                        ComponentTypeViewer.this.editName(ComponentTypeViewer.this.table, ComponentTypeViewer.this.editor, propertyInfo, selectedItem, column);
                        break;
                    }
                    case 1: {
                        ComponentTypeViewer.this.editType(ComponentTypeViewer.this.table, ComponentTypeViewer.this.editor, propertyInfo, selectedItem, column, true);
                        break;
                    }
                    case 2: {
                        ComponentTypeViewer.this.editValue(ComponentTypeViewer.this.table, ComponentTypeViewer.this.editor, propertyInfo, selectedItem, column, new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                ComponentTypeCommands.setDefaultValue(graph, (this).ComponentTypeViewer.this.componentType, propertyInfo.resource, newValue);
                            }
                        }, null);
                        break;
                    }
                    case 3: {
                        ComponentTypeViewer.this.editUnit(ComponentTypeViewer.this.table, ComponentTypeViewer.this.editor, propertyInfo, selectedItem, column);
                        break;
                    }
                    case 4: {
                        ComponentTypeViewer.this.editRange(ComponentTypeViewer.this.table, ComponentTypeViewer.this.editor, propertyInfo, selectedItem, selectedItemBounds, column);
                        break;
                    }
                    case 5: {
                        ComponentTypeViewer.this.editValue(ComponentTypeViewer.this.table, ComponentTypeViewer.this.editor, propertyInfo, selectedItem, column, new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                String value = newValue.isEmpty() ? null : newValue;
                                ComponentTypeCommands.setLabel(graph, resource, value);
                            }
                        }, null);
                        break;
                    }
                    case 6: {
                        ComponentTypeViewer.this.editMultilineText(ComponentTypeViewer.this.table, ComponentTypeViewer.this.editor, propertyInfo, selectedItem, selectedItemBounds, column, new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                String value = newValue.isEmpty() ? null : newValue;
                                ComponentTypeCommands.setDescription(graph, resource, value);
                            }
                        });
                    }
                }
            }
        });
        Composite buttons = this.tk.createComposite(sectionBody);
        GridDataFactory.fillDefaults().applyTo((Control)buttons);
        GridLayoutFactory.fillDefaults().applyTo(buttons);
        this.newProperty = this.tk.createButton(buttons, "New property", 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.newProperty);
        this.removeProperty = this.tk.createButton(buttons, "Remove property", 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.removeProperty);
        boolean bl = this.hasTypes = !this.getTypes().isEmpty();
        if (this.hasTypes) {
            this.setTypes = this.tk.createButton(buttons, "Assign Types", 8);
            GridDataFactory.fillDefaults().applyTo((Control)this.setTypes);
        }
        this.newProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentTypeViewer.this.editor.getEditor() != null) {
                    ComponentTypeViewer.this.editor.getEditor().dispose();
                }
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        ComponentTypeCommands.createPropertyWithDefaults(graph, (this).ComponentTypeViewer.this.componentType);
                    }
                });
            }
        });
        this.removeProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentTypeViewer.this.editor.getEditor() != null) {
                    ComponentTypeViewer.this.editor.getEditor().dispose();
                }
                final ArrayList<Resource> propertiesToBeRemoved = new ArrayList<Resource>();
                TableItem[] tableItemArray = ComponentTypeViewer.this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    propertiesToBeRemoved.add(((PropertyInfo)((Object)item.getData())).resource);
                    ++n2;
                }
                System.out.println("remove " + propertiesToBeRemoved.size() + " resources");
                if (!propertiesToBeRemoved.isEmpty()) {
                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            for (Resource property : propertiesToBeRemoved) {
                                ComponentTypeCommands.removeProperty(graph, (this).ComponentTypeViewer.this.componentType, property);
                            }
                        }
                    });
                }
            }
        });
        if (this.hasTypes) {
            this.setTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object[] result;
                    if (ComponentTypeViewer.this.editor.getEditor() != null) {
                        ComponentTypeViewer.this.editor.getEditor().dispose();
                    }
                    final ArrayList<Resource> propertiesToSet = new ArrayList<Resource>();
                    TableItem[] tableItemArray = ComponentTypeViewer.this.table.getSelection();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        propertiesToSet.add(((PropertyInfo)((Object)item.getData())).resource);
                        ++n2;
                    }
                    if (propertiesToSet.size() != 1) {
                        return;
                    }
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    SetTypesDialog page = new SetTypesDialog(shell, ComponentTypeViewer.this.getTypes(), "Select user types for property");
                    if (page.open() == 0 && (result = page.getResult()) != null && result.length > 0) {
                        Simantics.getSession().async((WriteInterface)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                Object[] objectArray = result;
                                int n = result.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object type = objectArray[n2];
                                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                                    graph.claim((Resource)propertiesToSet.get(0), L0.InstanceOf, null, (Resource)type);
                                    ++n2;
                                }
                            }
                        });
                    }
                }
            });
        }
        Section section2 = this.tk.createSection(this.form.getBody(), 320);
        FormData data3 = new FormData();
        data3.top = new FormAttachment((Control)sash);
        data3.left = new FormAttachment(0, 0);
        data3.right = new FormAttachment(100, 0);
        data3.bottom = new FormAttachment(100, 0);
        section2.setLayoutData((Object)data3);
        section.setLayout((Layout)new FillLayout());
        section2.setText("State properties");
        Composite sectionBody2 = this.tk.createComposite((Composite)section2);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionBody2);
        section2.setClient((Control)sectionBody2);
        Composite tableComposite2 = this.tk.createComposite(sectionBody2);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableComposite2);
        TableColumnLayout tcl2 = new TableColumnLayout();
        tableComposite2.setLayout((Layout)tcl2);
        this.table2 = this.tk.createTable(tableComposite2, 67586);
        this.table2.setLinesVisible(true);
        this.table2.setHeaderVisible(true);
        this.columns2 = new TableColumn[COLUMN_NAMES2.length];
        int i2 = 0;
        while (i2 < COLUMN_NAMES2.length) {
            TableColumn column;
            this.columns2[i2] = column = new TableColumn(this.table2, 0);
            tcl2.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(COLUMN_WEIGHTS2[i2], COLUMN_LENGTHS2[i2], true));
            column.setText(COLUMN_NAMES2[i2]);
            ++i2;
        }
        this.editor2 = new TableEditor(this.table2);
        this.editor2.grabHorizontal = true;
        this.editor2.grabVertical = true;
        this.editor2.horizontalAlignment = 16384;
        this.table2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Control oldEditor = ComponentTypeViewer.this.editor2.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if (ComponentTypeViewer.this.readOnly) {
                    return;
                }
                Rectangle tableBounds = ComponentTypeViewer.this.table2.getClientArea();
                int rx = e.x - tableBounds.x;
                int ry = e.y - tableBounds.y;
                TableItem selectedItem = null;
                int selectedColumn = -1;
                Rectangle selectedItemBounds = null;
                TableItem[] tableItemArray = ComponentTypeViewer.this.table2.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    int column = 0;
                    while (column < COLUMN_NAMES2.length) {
                        Rectangle bounds = item.getBounds(column);
                        if (bounds.contains(rx, ry)) {
                            selectedItemBounds = bounds;
                            selectedItem = item;
                            selectedColumn = column;
                            break;
                        }
                        ++column;
                    }
                    ++n2;
                }
                if (selectedItem == null) {
                    return;
                }
                int column = selectedColumn;
                PropertyInfo propertyInfo = (PropertyInfo)((Object)selectedItem.getData());
                final Resource resource = propertyInfo.resource;
                switch (column) {
                    case 0: {
                        ComponentTypeViewer.this.editName(ComponentTypeViewer.this.table2, ComponentTypeViewer.this.editor2, propertyInfo, selectedItem, column);
                        break;
                    }
                    case 1: {
                        ComponentTypeViewer.this.editType(ComponentTypeViewer.this.table2, ComponentTypeViewer.this.editor2, propertyInfo, selectedItem, column, false);
                        break;
                    }
                    case 2: {
                        ComponentTypeViewer.this.editValue(ComponentTypeViewer.this.table2, ComponentTypeViewer.this.editor2, propertyInfo, selectedItem, column, new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                ComponentTypeCommands.setMonitorExpression(graph, (this).ComponentTypeViewer.this.componentType, resource, newValue);
                            }
                        }, (Function4<RequestProcessor, Resource, Resource, String, String>)VALIDATE_MONITOR_EXPRESSION);
                        break;
                    }
                    case 3: {
                        ComponentTypeViewer.this.editValue(ComponentTypeViewer.this.table2, ComponentTypeViewer.this.editor2, propertyInfo, selectedItem, column, new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                String value = newValue.isEmpty() ? null : newValue;
                                ComponentTypeCommands.setLabel(graph, resource, value);
                            }
                        }, null);
                        break;
                    }
                    case 4: {
                        ComponentTypeViewer.this.editMultilineText(ComponentTypeViewer.this.table2, ComponentTypeViewer.this.editor2, propertyInfo, selectedItem, selectedItemBounds, column, new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                String value = newValue.isEmpty() ? null : newValue;
                                ComponentTypeCommands.setDescription(graph, resource, value);
                            }
                        });
                    }
                }
            }
        });
        Composite buttons2 = this.tk.createComposite(sectionBody2);
        GridDataFactory.fillDefaults().applyTo((Control)buttons2);
        GridLayoutFactory.fillDefaults().applyTo(buttons2);
        this.newProperty2 = this.tk.createButton(buttons2, "New property", 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.newProperty2);
        this.removeProperty2 = this.tk.createButton(buttons2, "Remove property", 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.removeProperty2);
        this.newProperty2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentTypeViewer.this.editor2.getEditor() != null) {
                    ComponentTypeViewer.this.editor2.getEditor().dispose();
                }
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        ComponentTypeCommands.createMonitorPropertyWithDefaults(graph, (this).ComponentTypeViewer.this.componentType);
                    }
                });
            }
        });
        this.removeProperty2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentTypeViewer.this.editor2.getEditor() != null) {
                    ComponentTypeViewer.this.editor2.getEditor().dispose();
                }
                final ArrayList<Resource> propertiesToBeRemoved = new ArrayList<Resource>();
                TableItem[] tableItemArray = ComponentTypeViewer.this.table2.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    propertiesToBeRemoved.add(((PropertyInfo)((Object)item.getData())).resource);
                    ++n2;
                }
                System.out.println("remove " + propertiesToBeRemoved.size() + " resources");
                if (!propertiesToBeRemoved.isEmpty()) {
                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            for (Resource property : propertiesToBeRemoved) {
                                ComponentTypeCommands.removeProperty(graph, (this).ComponentTypeViewer.this.componentType, property);
                            }
                        }
                    });
                }
            }
        });
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ComponentTypeViewer.this.tk.dispose();
            }
        });
        this.createGraphListener();
    }

    private Map<Resource, Pair<String, ImageDescriptor>> getTypes() {
        try {
            return (Map)Simantics.getSession().syncRequest((Read)new UniqueRead<Map<Resource, Pair<String, ImageDescriptor>>>(){

                public Map<Resource, Pair<String, ImageDescriptor>> perform(ReadGraph graph) throws DatabaseException {
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(ComponentTypeViewer.this.componentType));
                    Instances query = (Instances)graph.adapt(STR.UserDefinedProperty, Instances.class);
                    Collection types = query.find(graph, indexRoot);
                    HashMap<Resource, Pair<String, ImageDescriptor>> result = new HashMap<Resource, Pair<String, ImageDescriptor>>();
                    for (Resource type : types) {
                        String name = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)type);
                        result.put(type, (Pair<String, ImageDescriptor>)new Pair((Object)name, null));
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return Collections.emptyMap();
        }
    }

    protected void editName(Table table, TableEditor editor, final PropertyInfo propertyInfo, TableItem selectedItem, int column) {
        final Text text = new Text((Composite)table, 0);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 12) {
                    ComponentTypeViewer.this.form.setMessage(null);
                    return;
                }
                if (e.type == 24) {
                    String error = ComponentTypeViewer.this.validatePropertyName(propertyInfo, text.getText());
                    if (error != null) {
                        text.setBackground(text.getDisplay().getSystemColor(3));
                        ComponentTypeViewer.this.form.setMessage(error, 3);
                    } else {
                        text.setBackground(null);
                        ComponentTypeViewer.this.form.setMessage(null);
                    }
                    return;
                }
                if (e.type == 31) {
                    if (e.detail == 2) {
                        text.dispose();
                        e.doit = false;
                        return;
                    }
                    if (e.detail == 64 || e.detail == 32 || e.detail == 128) {
                        return;
                    }
                    e.doit = false;
                }
                final String newValue = text.getText();
                text.dispose();
                String error = ComponentTypeViewer.this.validatePropertyName(propertyInfo, newValue);
                if (error != null) {
                    return;
                }
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        ComponentTypeCommands.rename(graph, propertyInfo.resource, newValue);
                    }
                });
            }
        };
        text.addListener(24, listener);
        text.addListener(27, listener);
        text.addListener(31, listener);
        text.addListener(12, listener);
        text.setText(selectedItem.getText(column));
        text.selectAll();
        text.setFocus();
        editor.setEditor((Control)text, selectedItem, column);
    }

    protected void editType(Table table, TableEditor editor, final PropertyInfo propertyInfo, TableItem selectedItem, int column, final boolean convertDefaultValue) {
        final Combo combo = new Combo((Composite)table, 0);
        combo.setText(selectedItem.getText(column));
        String[] stringArray = PROPERTY_TYPE_SUGGESTIONS;
        int n = PROPERTY_TYPE_SUGGESTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String suggestion = stringArray[n2];
            combo.add(suggestion);
            ++n2;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    if (e.detail == 2) {
                        combo.dispose();
                        e.doit = false;
                        return;
                    }
                    if (e.detail == 64 || e.detail == 32 || e.detail == 128) {
                        return;
                    }
                }
                final String newValue = combo.getText();
                if (e.type == 31) {
                    e.doit = false;
                }
                combo.dispose();
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        ComponentTypeCommands.setRequiredType(graph, propertyInfo.resource, newValue);
                        if (convertDefaultValue) {
                            ComponentTypeCommands.convertDefaultValue(graph, (this).ComponentTypeViewer.this.componentType, propertyInfo.resource, newValue);
                            Map instances = (Map)graph.sync((ReadInterface)new ModelInstances((this).ComponentTypeViewer.this.componentType, (this).ComponentTypeViewer.this.componentType));
                            for (Resource instance : instances.values()) {
                                ComponentTypeCommands.convertInstantiatedValue(graph, instance, propertyInfo.resource, newValue);
                            }
                        }
                    }
                });
            }
        };
        combo.setFocus();
        editor.setEditor((Control)combo, selectedItem, column);
        combo.addListener(16, listener);
        combo.addListener(31, listener);
    }

    protected void editUnit(Table table, TableEditor editor, final PropertyInfo propertyInfo, TableItem selectedItem, int column) {
        if (propertyInfo.numberType == null && !propertyInfo.monitor) {
            return;
        }
        final Combo combo = new Combo((Composite)table, 0);
        String initialValue = selectedItem.getText(column);
        ArrayList units = new ArrayList(this.unitLibrary.getUnits());
        Collections.sort(units, String.CASE_INSENSITIVE_ORDER);
        int i = -1;
        int selected = -1;
        for (String unit : units) {
            combo.add(unit);
            if (!unit.equals(initialValue)) continue;
            combo.select(i);
        }
        if (selected == -1) {
            combo.setText(initialValue);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    if (e.detail == 2) {
                        combo.dispose();
                        e.doit = false;
                        return;
                    }
                    if (e.detail == 64 || e.detail == 32 || e.detail == 128) {
                        return;
                    }
                }
                final String newValue = combo.getText();
                if (e.type == 31) {
                    e.doit = false;
                }
                combo.dispose();
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        ComponentTypeCommands.setUnit(graph, (this).ComponentTypeViewer.this.componentType, propertyInfo.resource, newValue);
                    }
                });
            }
        };
        combo.setFocus();
        editor.setEditor((Control)combo, selectedItem, column);
        combo.addListener(27, listener);
        combo.addListener(31, listener);
    }

    protected void editValue(Table table, TableEditor editor, final PropertyInfo propertyInfo, TableItem selectedItem, int column, final StringWriter writer, final Function4<RequestProcessor, Resource, Resource, String, String> validator) {
        final Text text = new Text((Composite)table, 0);
        text.setText(selectedItem.getText(column));
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    if (e.detail == 2) {
                        text.dispose();
                        e.doit = false;
                        return;
                    }
                    if (e.detail == 64 || e.detail == 32 || e.detail == 128) {
                        return;
                    }
                }
                final String newValue = text.getText();
                if (e.type == 31) {
                    e.doit = false;
                }
                text.dispose();
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        if (writer != null) {
                            writer.perform(graph, newValue);
                        }
                    }
                });
            }
        };
        text.selectAll();
        text.setFocus();
        editor.setEditor((Control)text, selectedItem, column);
        text.addListener(16, listener);
        text.addListener(31, listener);
        if (validator != null) {
            Listener validationListener = new Listener(){

                public void handleEvent(Event e) {
                    String newValue = text.getText();
                    String error = (String)validator.apply((Object)Simantics.getSession(), (Object)ComponentTypeViewer.this.componentType, (Object)propertyInfo.resource, (Object)newValue);
                    if (error != null) {
                        text.setBackground(text.getDisplay().getSystemColor(3));
                        text.setToolTipText(error);
                        return;
                    }
                    text.setBackground(null);
                    text.setToolTipText(null);
                }
            };
            text.addListener(24, validationListener);
        }
    }

    protected void editRange(Table table, TableEditor editor, final PropertyInfo propertyInfo, TableItem selectedItem, Rectangle selectedItemBounds, int column) {
        if (propertyInfo.numberType == null) {
            return;
        }
        Range range = null;
        String rangeStr = selectedItem.getText(column);
        try {
            range = Range.valueOf((String)rangeStr);
        }
        catch (RangeException ex) {
            range = new Range(Limit.nolimit(), Limit.nolimit());
        }
        final Shell shell = new Shell(table.getShell(), 16384);
        GridLayoutFactory.fillDefaults().applyTo((Composite)shell);
        Composite composite = new Composite((Composite)shell, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
        Label low = new Label(composite, 0);
        low.setText("Minimum Value:");
        final Text lowText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)lowText);
        final Combo lowSelector = ComponentTypeViewer.createRangeInclusionCombo(composite, !range.getLower().isExclusive());
        Label high = new Label(composite, 0);
        high.setText("Maximum Value:");
        final Text highText = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)highText);
        final Combo highSelector = ComponentTypeViewer.createRangeInclusionCombo(composite, !range.getUpper().isExclusive());
        Composite buttonComposite = new Composite((Composite)shell, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(131072, 4).applyTo((Control)buttonComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(true).applyTo(buttonComposite);
        Button ok = new Button(buttonComposite, 0);
        ok.setText("&OK");
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)ok);
        Button cancel = new Button(buttonComposite, 0);
        cancel.setText("&Cancel");
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)ok);
        if (range.getLower().getValue() != null) {
            lowText.setText(range.getLower().getValue().toString());
        }
        if (range.getUpper().getValue() != null) {
            highText.setText(range.getUpper().getValue().toString());
        }
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    final Range newRange = ComponentTypeViewer.this.parseRange(propertyInfo.numberType, lowText.getText().trim(), highText.getText().trim(), lowSelector.getSelectionIndex() == 0, highSelector.getSelectionIndex() == 0);
                    shell.dispose();
                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            ComponentTypeCommands.setRange(graph, (this).ComponentTypeViewer.this.componentType, propertyInfo.resource, newRange == null ? null : newRange.toString());
                        }
                    });
                }
                catch (RangeException ex) {
                    ErrorLogger.defaultLogError((Throwable)ex);
                }
            }
        });
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.dispose();
            }
        });
        shell.pack();
        Point size = shell.getSize();
        Display display = table.getDisplay();
        Rectangle clientArea = display.getClientArea();
        Point bt = table.toDisplay(selectedItemBounds.x, selectedItemBounds.y);
        Rectangle b = selectedItemBounds;
        b.x = bt.x;
        b.y = bt.y;
        b.width = size.x;
        b.height = size.y;
        if (b.x + b.width > clientArea.width) {
            b.x -= b.x + b.width - clientArea.width;
        }
        if (b.height > clientArea.height) {
            b.height = clientArea.height;
        }
        if (b.y + b.height > clientArea.height) {
            b.y -= b.y + b.height - clientArea.height;
        }
        shell.setBounds(selectedItemBounds);
        shell.open();
    }

    protected void editMultilineText(Table table, TableEditor editor, PropertyInfo propertyInfo, TableItem selectedItem, Rectangle selectedItemBounds, int column, final StringWriter writer) {
        final Shell shell = new Shell(table.getShell(), 16384);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)shell);
        final StyledText text = new StyledText((Composite)shell, 578);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)text);
        text.setText(selectedItem.getText(column));
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                final String newValue = text.getText();
                if (e.type == 31) {
                    if (e.detail == 2) {
                        shell.dispose();
                        e.doit = false;
                        return;
                    }
                    if (e.detail == 64 || e.detail == 32 || e.detail == 128) {
                        return;
                    }
                    if ((e.stateMask & 0x40000) == 0) {
                        return;
                    }
                    e.doit = false;
                }
                shell.dispose();
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        if (writer != null) {
                            writer.perform(graph, newValue);
                        }
                    }
                });
            }
        };
        Label help = this.tk.createLabel((Composite)shell, "Ctrl+Enter to apply changes, ESC to cancel.", 0x800800);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)help);
        help.setForeground(this.tk.getColors().createColor("fg", this.tk.getColors().getSystemColor(26)));
        Display display = table.getDisplay();
        Rectangle clientArea = display.getClientArea();
        Point bt = table.toDisplay(selectedItemBounds.x, selectedItemBounds.y);
        Rectangle b = selectedItemBounds;
        b.x = bt.x;
        b.y = bt.y;
        b.height = 200;
        if (b.x + b.width > clientArea.width) {
            b.x -= b.x + b.width - clientArea.width;
        }
        if (b.height > clientArea.height) {
            b.height = clientArea.height;
        }
        if (b.y + b.height > clientArea.height) {
            b.y -= b.y + b.height - clientArea.height;
        }
        shell.setBounds(selectedItemBounds);
        shell.open();
        text.selectAll();
        text.setFocus();
        text.addListener(31, listener);
        shell.addListener(27, listener);
    }

    private void createGraphListener() {
        Simantics.getSession().asyncRequest((Read)new UniqueRead<Result>(){

            public Result perform(ReadGraph graph) throws DatabaseException {
                ArrayList<PropertyInfo> result = new ArrayList<PropertyInfo>();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                for (Resource relation : graph.getObjects(ComponentTypeViewer.this.componentType, L0.DomainOf)) {
                    String description;
                    if (!graph.isSubrelationOf(relation, L0.HasProperty)) continue;
                    String name = (String)graph.getRelatedValue(relation, L0.HasName);
                    String type = (String)graph.getPossibleRelatedValue(relation, L0.RequiresValueType);
                    String label = (String)graph.getPossibleRelatedValue(relation, L0.HasLabel);
                    if (label == null) {
                        label = "";
                    }
                    if ((description = (String)graph.getPossibleRelatedValue(relation, L0.HasDescription)) == null) {
                        description = "";
                    }
                    NumberType numberType = null;
                    if (type == null) {
                        type = "Double";
                    }
                    String unit = (String)graph.getPossibleRelatedValue(relation, L0X.HasUnit, (Binding)Bindings.STRING);
                    String defaultValue = "0";
                    String expression = null;
                    for (Resource assertion : graph.getAssertedObjects(ComponentTypeViewer.this.componentType, relation)) {
                        try {
                            expression = (String)graph.getPossibleRelatedValue(assertion, L0.SCLValue_expression, (Binding)Bindings.STRING);
                            Datatype dt = ComponentTypeViewer.this.getPossibleDatatype(graph, assertion);
                            if (dt == null) continue;
                            if (dt instanceof NumberType) {
                                numberType = (NumberType)dt;
                            }
                            Binding binding = Bindings.getBinding((Datatype)dt);
                            Object value = graph.getValue(assertion, binding);
                            try {
                                defaultValue = binding.toString(value, true);
                            }
                            catch (BindingException e) {
                                ErrorLogger.defaultLogError((Throwable)e);
                            }
                        }
                        catch (DatabaseException e) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                    }
                    String valid = expression != null ? ComponentTypeViewer.validateMonitorExpression((RequestProcessor)graph, ComponentTypeViewer.this.componentType, relation, expression) : null;
                    Resource range = graph.getPossibleObject(relation, L0.HasRange);
                    boolean monitor = range != null && graph.isInstanceOf(range, STR.MonitorValueType);
                    result.add(new PropertyInfo(relation, name, type, defaultValue, numberType, unit, label, description, expression, valid, monitor));
                }
                Collections.sort(result);
                XSupport xs = (XSupport)graph.peekService(XSupport.class);
                boolean immutable = xs != null ? xs.getImmutable(ComponentTypeViewer.this.componentType) : false;
                return new Result(result, immutable);
            }
        }, (org.simantics.db.procedure.Listener)new org.simantics.db.procedure.Listener<Result>(){

            public void execute(final Result result) {
                SWTUtils.asyncExec((Widget)ComponentTypeViewer.this.table, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ComponentTypeViewer.this.table.isDisposed()) {
                            return;
                        }
                        (this).ComponentTypeViewer.this.properties = result.getProperties().toArray(new PropertyInfo[result.getProperties().size()]);
                        HashSet<PropertyInfo> selected = new HashSet<PropertyInfo>();
                        ArrayList<TableItem> selectedItems = new ArrayList<TableItem>(selected.size());
                        int[] nArray = (this).ComponentTypeViewer.this.table.getSelectionIndices();
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int i = nArray[n2];
                            TableItem item = (this).ComponentTypeViewer.this.table.getItem(i);
                            selected.add((PropertyInfo)((Object)item.getData()));
                            ++n2;
                        }
                        HashSet<PropertyInfo> selected2 = new HashSet<PropertyInfo>();
                        ArrayList<TableItem> selectedItems2 = new ArrayList<TableItem>(selected2.size());
                        int[] nArray2 = (this).ComponentTypeViewer.this.table2.getSelectionIndices();
                        int item = nArray2.length;
                        int n3 = 0;
                        while (n3 < item) {
                            int i = nArray2[n3];
                            TableItem item2 = (this).ComponentTypeViewer.this.table2.getItem(i);
                            selected2.add((PropertyInfo)((Object)item2.getData()));
                            ++n3;
                        }
                        (this).ComponentTypeViewer.this.table.removeAll();
                        (this).ComponentTypeViewer.this.table2.removeAll();
                        if ((this).ComponentTypeViewer.this.editor.getEditor() != null) {
                            (this).ComponentTypeViewer.this.editor.getEditor().dispose();
                        }
                        if ((this).ComponentTypeViewer.this.editor2.getEditor() != null) {
                            (this).ComponentTypeViewer.this.editor2.getEditor().dispose();
                        }
                        for (PropertyInfo info : result.getProperties()) {
                            TableItem tableItem = item = info.monitor ? new TableItem((this).ComponentTypeViewer.this.table2, 0) : new TableItem((this).ComponentTypeViewer.this.table, 0);
                            if (info.monitor) {
                                item.setText(0, info.valid != null ? String.valueOf(info.name) + " (!)" : info.name);
                                item.setText(1, info.type);
                                item.setText(2, info.expression);
                                item.setText(3, info.label);
                                item.setText(4, info.description);
                            } else {
                                item.setText(0, info.name);
                                item.setText(1, info.type);
                                item.setText(2, info.defaultValue);
                                item.setText(3, ComponentTypeViewer.this.unitStr(info));
                                item.setText(4, ComponentTypeViewer.this.rangeStr(info));
                                item.setText(5, info.label);
                                item.setText(6, info.description);
                            }
                            item.setData((Object)info);
                            if (selected.contains((Object)info)) {
                                selectedItems.add(item);
                            }
                            if (!selected2.contains((Object)info)) continue;
                            selectedItems2.add(item);
                        }
                        (this).ComponentTypeViewer.this.table.setSelection(selectedItems.toArray(new TableItem[selectedItems.size()]));
                        (this).ComponentTypeViewer.this.table2.setSelection(selectedItems2.toArray(new TableItem[selectedItems2.size()]));
                        (this).ComponentTypeViewer.this.table.redraw();
                        (this).ComponentTypeViewer.this.table2.redraw();
                        ComponentTypeViewer.this.setReadOnly(result.isImmutable());
                    }
                });
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }

            public boolean isDisposed() {
                return ComponentTypeViewer.this.table.isDisposed();
            }
        });
    }

    private String unitStr(PropertyInfo info) {
        String unit;
        String string = unit = info.numberType == null ? null : info.numberType.getUnit();
        if (unit == null) {
            unit = info.unit;
        }
        return unit != null ? unit : "";
    }

    private String rangeStr(PropertyInfo info) {
        String range = info.numberType == null ? null : info.numberType.getRangeStr();
        return range != null ? range : "";
    }

    protected Datatype getPossibleDatatype(ReadGraph graph, Resource literal) throws DatabaseException {
        Binding binding = Bindings.getBindingUnchecked(Datatype.class);
        for (Resource dataTypeResource : graph.getObjects(literal, Layer0.getInstance((ReadGraph)graph).HasDataType)) {
            Datatype dt = (Datatype)graph.getPossibleValue(dataTypeResource, binding);
            if (dt == null) continue;
            return dt;
        }
        return null;
    }

    public void setFocus() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setFocus();
        }
    }

    private Range parseRange(NumberType numberType, String minStr, String maxStr, boolean lowInclusive, boolean highInclusive) throws RangeException {
        try {
            String rangeStr = String.valueOf(lowInclusive ? "[" : "(") + minStr + ".." + maxStr + (highInclusive ? "]" : ")");
            return Range.valueOf((String)rangeStr);
        }
        catch (IllegalArgumentException e) {
            throw new RangeException(e.getMessage(), (Throwable)e);
        }
    }

    private String validatePropertyName(PropertyInfo propertyInfo, String propertyName) {
        if (propertyName.equals(propertyInfo.name)) {
            return null;
        }
        PropertyInfo[] propertyInfoArray = this.properties;
        int n = this.properties.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyInfo info = propertyInfoArray[n2];
            if (propertyName.equals(info.name)) {
                return "Property name '" + propertyName + "' is already in use.";
            }
            ++n2;
        }
        Matcher m = PROPERTY_NAME_PATTERN.matcher(propertyName);
        if (!m.matches()) {
            return "Property name '" + propertyName + "' contains invalid characters, does not match pattern " + PROPERTY_NAME_PATTERN.pattern() + ".";
        }
        return null;
    }

    private static String validateMonitorExpression(RequestProcessor processor, final Resource componentType, final Resource relation, final String expression) {
        if (expression.trim().isEmpty()) {
            return "Expression is empty.";
        }
        if (expression.trim().isEmpty()) {
            return "Expression is empty.";
        }
        try {
            return (String)processor.sync((ReadInterface)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(componentType));
                    for (Resource literal : graph.getAssertedObjects(componentType, relation)) {
                        try {
                            if (graph.isInstanceOf(componentType, STR.ProceduralComponentType)) {
                                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                                Resource environment = graph.getPossibleObject(literal, L0.SCLValue_environment);
                                ContextModule context = (ContextModule)graph.sync((ReadInterface)new TypeMonitorContextRequest(componentType));
                                String SCLMain = (String)graph.syncRequest((Read)new SCLMainModuleRequest(indexRoot));
                                CompilationContext cc = new CompilationContext(environment, context, SCLMain);
                                graph.syncRequest((Read)new ActualCompileRequest(expression, cc), (org.simantics.db.procedure.Listener)TransientCacheListener.instance());
                                continue;
                            }
                            CompilationContext cc = new CompileSCLMonitorRequest(literal, componentType, indexRoot).getContext(graph);
                            graph.syncRequest((Read)new ActualCompileRequest(expression, cc), (org.simantics.db.procedure.Listener)TransientCacheListener.instance());
                        }
                        catch (Exception e) {
                            String msg = e.getMessage();
                            int index = msg.indexOf(":");
                            if (index > 0) {
                                msg = msg.substring(index);
                            }
                            return msg;
                        }
                    }
                    return null;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setReadOnly(boolean readOnly) {
        if (readOnly == this.readOnly) {
            return;
        }
        boolean e = !readOnly;
        this.readOnly = true;
        this.newProperty.setEnabled(e);
        this.removeProperty.setEnabled(e);
        this.newProperty2.setEnabled(e);
        this.removeProperty2.setEnabled(e);
        IMessageManager mm = this.form.getMessageManager();
        if (readOnly) {
            mm.addMessage((Object)"readonly", "(Opened in read-only mode)", null, 1);
        } else {
            mm.removeMessage((Object)"readonly");
        }
    }

    private static Combo createRangeInclusionCombo(Composite parent, boolean inclusive) {
        Combo rng = new Combo(parent, 8);
        rng.add("Inclusive");
        rng.add("Exclusive");
        rng.select(inclusive ? 0 : 1);
        return rng;
    }

    static class PropertyInfo
    extends Bean {
        Resource resource;
        String name;
        String type;
        String defaultValue;
        String label;
        String description;
        @Optional
        String expression;
        @Optional
        String valid;
        boolean monitor;
        @Optional
        NumberType numberType;
        @Optional
        String unit;

        public PropertyInfo(Resource resource, String name, String type, String defaultValue, NumberType numberType, String unit, String label, String description, String expression, String valid, boolean monitor) {
            this.resource = resource;
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
            this.numberType = numberType;
            this.unit = unit;
            this.label = label;
            this.description = description;
            this.expression = expression;
            this.valid = valid;
            this.monitor = monitor;
        }

        public int compareTo(Bean o) {
            if (o instanceof PropertyInfo) {
                return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)this.name, (Object)((PropertyInfo)o).name);
            }
            return 0;
        }
    }

    static class Result
    extends Tuple2 {
        public Result(List<PropertyInfo> properties, boolean immutable) {
            super(properties, (Object)immutable);
        }

        public List<PropertyInfo> getProperties() {
            return (List)this.c0;
        }

        public boolean isImmutable() {
            return (Boolean)this.c1;
        }
    }

    static interface StringWriter {
        public void perform(WriteGraph var1, String var2) throws DatabaseException;
    }
}

