/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.NewSymbol;
import org.simantics.modeling.ui.componentTypeEditor.TypeConversion;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;

public class ComponentTypeCommands {
    public static void applyCode(WriteGraph g, Resource componentType, String code) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        g.claimLiteral(componentType, STR.ProceduralComponentType_code, (Object)code, (Binding)Bindings.STRING);
    }

    public static void createConnectionPoint(WriteGraph g, Resource componentType, Resource cp) throws DatabaseException {
        StructuralUtils.createConnectionPoint((WriteGraph)g, (Resource)componentType, (Resource)cp);
    }

    public static Resource createMonitorPropertyWithDefaults(WriteGraph g, Resource componentType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        Resource monitorType = g.getPossibleObject(componentType, STR.ComponentType_HasDefaultMonitorValueType);
        if (monitorType == null) {
            monitorType = MOD.MonitorValue;
        }
        Resource relation = ComponentTypeCommands.createPropertyWithDefaultsBase(g, componentType);
        g.claim(relation, L0.HasRange, monitorType);
        Resource assertion = g.newResource();
        g.claim(componentType, L0.Asserts, assertion);
        g.claim(assertion, L0.InstanceOf, L0.Assertion);
        g.claim(assertion, L0.HasPredicate, relation);
        Resource value = g.newResource();
        g.claim(value, L0.InstanceOf, monitorType);
        g.claimLiteral(value, L0.HasValueType, L0.String, (Object)"Double", (Binding)Bindings.STRING);
        g.claimLiteral(value, L0.SCLValue_expression, L0.String, (Object)"", (Binding)Bindings.STRING);
        g.claim(assertion, L0.HasObject, value);
        return relation;
    }

    public static Resource createPropertyWithDefaults(WriteGraph g, Resource componentType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource relation = ComponentTypeCommands.createPropertyWithDefaultsBase(g, componentType);
        Resource assertion = g.newResource();
        g.claim(componentType, L0.Asserts, assertion);
        g.claim(assertion, L0.InstanceOf, L0.Assertion);
        g.claim(assertion, L0.HasPredicate, relation);
        Resource value = g.newResource();
        g.claim(value, L0.InstanceOf, L0.Literal);
        g.claimLiteral(value, L0.HasDataType, L0.DataType, (Object)Datatypes.DOUBLE, Bindings.getBindingUnchecked(Datatype.class));
        g.claimLiteral(value, L0.HasValueType, L0.String, (Object)"Double", (Binding)Bindings.STRING);
        g.claimValue(value, (Object)0.0, (Binding)Bindings.DOUBLE);
        g.claim(assertion, L0.HasObject, value);
        return relation;
    }

    public static Resource createPropertyWithDefaultsBase(WriteGraph g, Resource componentType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        String name = NameUtils.findFreshEscapedName((ReadGraph)g, (String)"newProperty", (Resource)componentType);
        Resource relation = g.newResource();
        g.claim(relation, L0.SubrelationOf, null, L0.HasProperty);
        boolean hadProperty = false;
        for (Resource type : g.getObjects(componentType, STR.ComponentType_HasDefaultPropertyRelationType)) {
            if (g.isInheritedFrom(type, STR.Property)) {
                hadProperty = true;
            }
            g.claim(relation, L0.InstanceOf, type);
        }
        if (!hadProperty) {
            g.claim(relation, L0.InstanceOf, STR.Property);
        }
        g.claimLiteral(relation, L0.HasName, (Object)name);
        g.claim(componentType, L0.ConsistsOf, L0.PartOf, relation);
        g.claim(relation, L0.HasDomain, L0.DomainOf, componentType);
        Resource invRelation = g.newResource();
        g.claim(invRelation, L0.SubrelationOf, null, L0.PropertyOf);
        g.claim(relation, L0.ConsistsOf, L0.PartOf, invRelation);
        g.claimLiteral(invRelation, L0.HasName, (Object)"Inverse");
        g.claim(relation, L0.InverseOf, invRelation);
        g.claimLiteral(relation, L0.RequiresValueType, (Object)"Double");
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Created new property " + name + " for annotation type " + componentType));
        return relation;
    }

    public static Resource createProperty(WriteGraph graph, Resource componentType, String name, String type, String unit, String range, String label, String description) throws DatabaseException {
        Resource property = ComponentTypeCommands.createPropertyWithDefaults(graph, componentType);
        ComponentTypeCommands.rename(graph, property, name);
        ComponentTypeCommands.setRequiredType(graph, property, type);
        ComponentTypeCommands.convertDefaultValue(graph, componentType, property, type);
        if (!type.equals("String")) {
            ComponentTypeCommands.setUnit(graph, componentType, property, unit);
            ComponentTypeCommands.setRange(graph, componentType, property, range);
        }
        ComponentTypeCommands.setLabel(graph, property, label);
        ComponentTypeCommands.setDescription(graph, property, description);
        return property;
    }

    public static void removeProperty(WriteGraph g, Resource componentType, Resource property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        for (Resource assertion : g.getObjects(property, L0.HasPredicateInverse)) {
            g.deny(assertion);
        }
        g.deny(property);
        String name = (String)g.getPossibleRelatedValue2(componentType, L0.HasName);
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Removed property " + property + " from component/annotation " + name + ", resource " + componentType));
    }

    public static void rename(WriteGraph g, Resource resource, String newName) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        String prevName = (String)g.getPossibleRelatedValue2(resource, L0.HasName);
        g.claimLiteral(resource, L0.HasName, (Object)newName);
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Renamed component/annotation type from " + prevName + " to " + newName + ", resource " + resource));
    }

    public static void setRequiredType(WriteGraph g, Resource resource, String requiredType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        g.claimLiteral(resource, L0.RequiresValueType, (Object)requiredType);
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Set required type " + requiredType + " for component/annotation " + resource));
    }

    public static Resource getAssertedObject(ReadGraph g, Resource type, Resource relation) throws DatabaseException {
        return (Resource)((Map)g.syncRequest((Read)new AssertionMap(type))).get(relation);
    }

    public static void setMonitorExpression(WriteGraph g, Resource type, Resource relation, String valueText) throws DatabaseException {
        Resource object = ComponentTypeCommands.getAssertedObject((ReadGraph)g, type, relation);
        if (object == null) {
            System.err.println("Didn't find assertion for " + NameUtils.getSafeName((ReadGraph)g, (Resource)relation) + " in " + NameUtils.getSafeName((ReadGraph)g, (Resource)type) + ".");
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        g.claimLiteral(object, L0.SCLValue_expression, (Object)valueText, (Binding)Bindings.STRING);
    }

    public static void setDefaultValue(WriteGraph g, Resource type, Resource relation, String valueText) throws DatabaseException {
        Resource object = ComponentTypeCommands.getAssertedObject((ReadGraph)g, type, relation);
        if (object == null) {
            System.err.println("Didn't find assertion for " + NameUtils.getSafeName((ReadGraph)g, (Resource)relation) + " in " + NameUtils.getSafeName((ReadGraph)g, (Resource)type) + ".");
            return;
        }
        Datatype dt = g.getDataType(object);
        Binding binding = Bindings.getBinding((Datatype)dt);
        try {
            Object value = binding.parseValue(valueText, new DataValueRepository());
            g.claimValue(object, value, binding);
        }
        catch (DataTypeSyntaxError e) {
            e.printStackTrace();
        }
        catch (BindingException e) {
            e.printStackTrace();
        }
    }

    public static void setUnit(WriteGraph graph, Resource type, Resource relation, String unit) throws DatabaseException {
        Resource object = ComponentTypeCommands.getAssertedObject((ReadGraph)graph, type, relation);
        if (object == null) {
            System.err.println("Didn't find assertion for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)relation) + " in " + NameUtils.getSafeName((ReadGraph)graph, (Resource)type) + ".");
            return;
        }
        Datatype dt = graph.getDataType(object);
        if (dt instanceof NumberType) {
            NumberType nt = (NumberType)dt;
            Binding ntb = Bindings.getBindingUnchecked(Datatype.class);
            nt.setUnit(unit);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            String oldUnit = (String)graph.getPossibleRelatedValue2(relation, L0X.HasUnit, (Binding)Bindings.STRING);
            graph.claimLiteral(object, L0.HasDataType, L0.DataType, (Object)nt, ntb);
            graph.claimLiteral(relation, L0X.RequiresDataType, L0.DataType, (Object)nt, ntb);
            graph.claimLiteral(relation, L0X.HasUnit, (Object)unit, (Binding)Bindings.STRING);
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Setted unit from " + oldUnit + " to " + unit + " for component/annotation " + type));
        }
    }

    public static void setRange(WriteGraph graph, Resource type, Resource relation, String newRange) throws DatabaseException {
        Resource object = ComponentTypeCommands.getAssertedObject((ReadGraph)graph, type, relation);
        if (object == null) {
            System.err.println("Didn't find assertion for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)relation) + " in " + NameUtils.getSafeName((ReadGraph)graph, (Resource)type) + ".");
            return;
        }
        Datatype dt = graph.getDataType(object);
        if (dt instanceof NumberType) {
            NumberType nt = (NumberType)dt;
            Binding ntb = Bindings.getBindingUnchecked(Datatype.class);
            nt.setRange(newRange);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            graph.claimLiteral(object, L0.HasDataType, L0.DataType, (Object)nt, ntb);
            graph.claimLiteral(relation, L0X.RequiresDataType, L0.DataType, (Object)nt, ntb);
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Setted range " + newRange + " for component/annotation " + type));
        }
    }

    public static Tuple getDatatypeValueAndBinding(ReadGraph g, Resource object, String newSCLType) throws DatabaseException {
        Object newValue;
        Datatype newDatatype = TypeConversion.convertSCLTypeToDatatype(newSCLType);
        if (newDatatype == null) {
            System.err.println("Couldn't convert default value to <" + newSCLType + ">.");
            return null;
        }
        Binding newBinding = Bindings.getBinding((Datatype)newDatatype);
        Datatype oldDatatype = g.getDataType(object);
        Binding oldBinding = Bindings.getBinding((Datatype)oldDatatype);
        Object oldValue = g.getValue(object, oldBinding);
        try {
            newValue = Bindings.adapt((Object)oldValue, (Binding)oldBinding, (Binding)newBinding);
        }
        catch (AdaptException e) {
            try {
                newValue = newBinding.createDefault();
            }
            catch (BindingException e1) {
                e1.printStackTrace();
                return null;
            }
        }
        return new Tuple3((Object)newDatatype, newValue, (Object)newBinding);
    }

    public static void convertDefaultValue(WriteGraph g, Resource type, Resource relation, String newSCLType) throws DatabaseException {
        Resource object = ComponentTypeCommands.getAssertedObject((ReadGraph)g, type, relation);
        if (object == null) {
            System.err.println("Didn't find assertion for " + NameUtils.getSafeName((ReadGraph)g, (Resource)relation) + " in " + NameUtils.getSafeName((ReadGraph)g, (Resource)type) + ".");
            return;
        }
        Tuple tuple = ComponentTypeCommands.getDatatypeValueAndBinding((ReadGraph)g, object, newSCLType);
        if (tuple == null) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        g.claimLiteral(object, L0.HasDataType, L0.DataType, tuple.get(0), Bindings.getBindingUnchecked(Datatype.class));
        g.claimLiteral(object, L0.HasValueType, g.getRelatedValue(relation, L0.RequiresValueType, (Binding)Bindings.STRING), (Binding)Bindings.STRING);
        g.claimValue(object, tuple.get(1), (Binding)tuple.get(2));
    }

    public static void convertInstantiatedValue(WriteGraph g, Resource instance, Resource relation, String newSCLType) throws DatabaseException {
        Statement stm = g.getPossibleStatement(instance, relation);
        if (stm != null && !stm.isAsserted(instance)) {
            Resource object = stm.getObject();
            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
            if (!g.isInstanceOf(object, L0.Literal)) {
                return;
            }
            Tuple tuple = ComponentTypeCommands.getDatatypeValueAndBinding((ReadGraph)g, object, newSCLType);
            g.claimLiteral(object, L0.HasDataType, L0.DataType, tuple.get(0), Bindings.getBindingUnchecked(Datatype.class));
            g.claimLiteral(object, L0.HasValueType, g.getRelatedValue(relation, L0.RequiresValueType, (Binding)Bindings.STRING), (Binding)Bindings.STRING);
            g.claimValue(object, tuple.get(1), (Binding)tuple.get(2));
        }
    }

    public static void setLabel(WriteGraph graph, Resource relation, String newLabel) throws DatabaseException {
        ComponentTypeCommands.setProperty(graph, relation, Layer0.getInstance((ReadGraph)graph).HasLabel, newLabel);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Setted label " + newLabel + " for component/annotation " + relation));
    }

    public static void setDescription(WriteGraph graph, Resource relation, String newDescription) throws DatabaseException {
        ComponentTypeCommands.setProperty(graph, relation, Layer0.getInstance((ReadGraph)graph).HasDescription, newDescription);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Setted description for component/annotation " + relation));
    }

    public static void setProperty(WriteGraph graph, Resource relation, Resource property, String newValue) throws DatabaseException {
        if (newValue != null) {
            graph.claimLiteral(relation, property, (Object)newValue, (Binding)Bindings.STRING);
        } else {
            graph.denyValue(relation, property);
        }
    }

    public static Resource createSymbol(WriteGraph graph, Resource componentType) throws DatabaseException {
        return NewSymbol.createSymbol((WriteGraph)graph, (Resource)componentType);
    }

    static class AssertionMap
    extends UnaryRead<Resource, Map<Resource, Resource>> {
        public AssertionMap(Resource parameter) {
            super((Object)parameter);
        }

        public Map<Resource, Resource> perform(ReadGraph graph) throws DatabaseException {
            THashMap result = new THashMap();
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Resource assertion : graph.getObjects((Resource)this.parameter, L0.Asserts)) {
                result.put((Object)graph.getSingleObject(assertion, L0.HasPredicate), (Object)graph.getSingleObject(assertion, L0.HasObject));
            }
            return result;
        }
    }
}

