/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.modeling.ui.Activator;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.strings.format.MetricsFormat;
import org.simantics.utils.strings.format.MetricsFormatList;
import org.simantics.utils.strings.format.MetricsFormatListListener;
import org.simantics.utils.ui.ErrorLogger;

public class EditStyleHandler
extends AbstractHandler {
    private static final String SECTION_AWT_STYLE_DIALOG = "AWTStyleDialog";
    private static final String SETTING_DIALOG_HEIGHT = "h";
    private static final String SETTING_DIALOG_WIDTH = "w";
    private static final String SETTING_DIALOG_Y = "y";
    private static final String SETTING_DIALOG_X = "x";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Resource[] resources = ResourceAdaptionUtils.toResources((Object)s);
        if (resources.length != 0) {
            EditStyleHandler.openStyleDialog(resources);
        }
        return null;
    }

    public static void openStyleDialog(final Resource[] resources) {
        if (resources.length == 0) {
            return;
        }
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
                DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                boolean hasStyle = true;
                Color color = null;
                Font font = null;
                MetricsFormat format = null;
                boolean hasColor = true;
                boolean hasFont = true;
                boolean hasFormat = true;
                Resource[] resourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource r = resourceArray[n2];
                    if (!graph.isInstanceOf(r, dr.StyleProvider)) {
                        hasStyle = false;
                        break;
                    }
                    if (graph.isInstanceOf(r, dr.FontProvider)) {
                        Resource fontR;
                        if (font == null && (fontR = graph.getPossibleObject(r, g2d.HasFont)) != null) {
                            font = G2DUtils.getFont((ReadGraph)graph, (Resource)fontR);
                        }
                    } else {
                        hasFont = false;
                    }
                    if (graph.isInstanceOf(r, dr.ColorProvider)) {
                        Resource colorR;
                        if (color == null && (colorR = graph.getPossibleObject(r, g2d.HasColor)) != null) {
                            color = G2DUtils.getColor((ReadGraph)graph, (Resource)colorR);
                        }
                    } else {
                        hasColor = false;
                    }
                    if (graph.isInstanceOf(r, dr.FormatProvider)) {
                        Resource formatR;
                        if (format == null && (formatR = graph.getPossibleObject(r, dr.HasFormat)) != null) {
                            format = G2DUtils.getMetricsFormat((ReadGraph)graph, (Resource)formatR);
                        }
                    } else {
                        hasFormat = false;
                    }
                    ++n2;
                }
                if (!hasStyle) {
                    return;
                }
                if (!(hasFont || hasColor || hasFormat)) {
                    return;
                }
                final Font currentFont = font;
                final Color currentColor = color;
                final MetricsFormat currentFormat = format;
                final boolean useFont = hasFont;
                final boolean useColor = hasColor;
                final boolean useFormat = hasFormat;
                Job job = new Job("Open Style Dialog"){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Open dialog", -1);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.setThread(Thread.currentThread());
                                try {
                                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                                }
                                catch (ClassNotFoundException e) {
                                    ErrorLogger.defaultLogError((Throwable)e);
                                }
                                catch (InstantiationException e) {
                                    ErrorLogger.defaultLogError((Throwable)e);
                                }
                                catch (IllegalAccessException e) {
                                    ErrorLogger.defaultLogError((Throwable)e);
                                }
                                catch (UnsupportedLookAndFeelException e) {
                                    ErrorLogger.defaultLogError((Throwable)e);
                                }
                                AWTStyleDialog dialog = new AWTStyleDialog(useFont, useColor, useFormat);
                                if (useColor && currentColor != null) {
                                    dialog.setStartColor(currentColor);
                                }
                                if (useFont && currentFont != null) {
                                    dialog.setStartFont(currentFont);
                                }
                                if (useFormat && currentFormat != null) {
                                    dialog.setStartFormat(currentFormat);
                                }
                                IDialogSettings ds = Activator.getDefault().getDialogSettings();
                                IDialogSettings sd = ds.getSection(EditStyleHandler.SECTION_AWT_STYLE_DIALOG);
                                boolean restoredSettings = false;
                                if (sd == null) {
                                    sd = ds.addNewSection(EditStyleHandler.SECTION_AWT_STYLE_DIALOG);
                                } else {
                                    try {
                                        int x = sd.getInt(EditStyleHandler.SETTING_DIALOG_X);
                                        int y = sd.getInt(EditStyleHandler.SETTING_DIALOG_Y);
                                        int w = sd.getInt(EditStyleHandler.SETTING_DIALOG_WIDTH);
                                        int h = sd.getInt(EditStyleHandler.SETTING_DIALOG_HEIGHT);
                                        if (w > 0 && h > 0) {
                                            dialog.setLocation(x, y);
                                            dialog.setSize(w, h);
                                            restoredSettings = true;
                                        }
                                    }
                                    catch (NumberFormatException x) {
                                        // empty catch block
                                    }
                                }
                                if (!restoredSettings) {
                                    dialog.setLocationByPlatform(true);
                                    dialog.pack();
                                }
                                this.done(Status.OK_STATUS);
                                dialog.setVisible(true);
                                Point loc = dialog.getLocation();
                                Dimension dim = dialog.getSize();
                                sd.put(EditStyleHandler.SETTING_DIALOG_X, loc.x);
                                sd.put(EditStyleHandler.SETTING_DIALOG_Y, loc.y);
                                sd.put(EditStyleHandler.SETTING_DIALOG_WIDTH, dim.width);
                                sd.put(EditStyleHandler.SETTING_DIALOG_HEIGHT, dim.height);
                                if (!dialog.isCancelled()) {
                                    final Font font = dialog.getFont();
                                    final Color color = dialog.getColor();
                                    final MetricsFormat format = dialog.getFormat();
                                    SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                                        public void perform(WriteGraph graph) throws DatabaseException {
                                            G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
                                            DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                                            Resource fontResource = null;
                                            if (useFont) {
                                                fontResource = G2DUtils.createFont((WriteGraph)graph, (Font)font);
                                            }
                                            Resource colorResource = null;
                                            if (useColor) {
                                                colorResource = G2DUtils.createColor((WriteGraph)graph, (Color)color);
                                            }
                                            Resource formatResource = null;
                                            if (useFormat) {
                                                formatResource = G2DUtils.createMetricsFormat((WriteGraph)graph, (MetricsFormat)format);
                                            }
                                            Resource[] resourceArray = resources;
                                            int n = resources.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                Resource r = resourceArray[n2];
                                                if (useFont && graph.isInstanceOf(r, dr.FontProvider)) {
                                                    graph.deny(r, g2d.HasFont);
                                                    graph.claim(r, g2d.HasFont, fontResource);
                                                }
                                                if (useColor && graph.isInstanceOf(r, dr.ColorProvider)) {
                                                    graph.deny(r, g2d.HasColor);
                                                    graph.claim(r, g2d.HasColor, colorResource);
                                                }
                                                if (useFormat && graph.isInstanceOf(r, dr.FormatProvider)) {
                                                    graph.deny(r, dr.HasFormat);
                                                    graph.claim(r, dr.HasFormat, formatResource);
                                                }
                                                ++n2;
                                            }
                                        }
                                    });
                                }
                            }
                        });
                        return Job.ASYNC_FINISH;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        });
    }

    public static class AWTStyleDialog
    extends JDialog {
        private static final long serialVersionUID = 6836378345175793069L;
        private FontChooser fontChooser;
        private JColorChooser colorChooser;
        private MetricsEditor metricsEditor;
        private boolean cancelled = true;
        private boolean useFont = true;
        private boolean useColor = true;
        private boolean useFormat = true;

        public AWTStyleDialog(Frame owner, boolean useFont, boolean useColor, boolean useFormat) {
            super(owner, "Style", true);
            this.useFont = useFont;
            this.useColor = useColor;
            this.useFormat = useFormat;
            this.createContents();
        }

        public AWTStyleDialog(boolean useFont, boolean useColor, boolean useFormat) {
            this.setTitle("Style");
            this.setModal(true);
            this.useFont = useFont;
            this.useColor = useColor;
            this.useFormat = useFormat;
            this.createContents();
        }

        public void setStartFont(Font font) {
            if (!this.useFont) {
                throw new RuntimeException("Dialog is not configured with font support");
            }
            this.fontChooser.setCurrentFont(font);
        }

        public void setStartColor(Color color) {
            if (!this.useColor) {
                throw new RuntimeException("Dialog is not configured with color support");
            }
            this.colorChooser.setColor(color);
        }

        public void setStartFormat(MetricsFormat format) {
            if (!this.useFormat) {
                throw new RuntimeException("Dialog is not configured with format support");
            }
            this.metricsEditor.setMetricsFormat(format);
        }

        private void createContents() {
            JTabbedPane tabbedPane = new JTabbedPane();
            this.getContentPane().add((Component)tabbedPane, "Center");
            if (this.useFont) {
                this.fontChooser = new FontChooser("Sample text");
                tabbedPane.addTab("Font", this.fontChooser);
            }
            if (this.useColor) {
                this.colorChooser = new JColorChooser(new Color(0, 0, 0));
                tabbedPane.addTab("Color", this.colorChooser);
            }
            if (this.useFormat) {
                this.metricsEditor = new MetricsEditor();
                tabbedPane.addTab("Metrics", this.metricsEditor);
            }
            JPanel controlPanel = new JPanel();
            this.getContentPane().add((Component)controlPanel, "South");
            controlPanel.setLayout(new FlowLayout(2));
            JButton okButton = new JButton("OK");
            controlPanel.add(okButton);
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AWTStyleDialog.this.cancelled = false;
                    AWTStyleDialog.this.setVisible(false);
                    AWTStyleDialog.this.dispose();
                }
            });
            JButton cancelButton = new JButton("Cancel");
            controlPanel.add(cancelButton);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AWTStyleDialog.this.setVisible(false);
                    AWTStyleDialog.this.dispose();
                }
            });
            this.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent arg0) {
                }

                @Override
                public void windowIconified(WindowEvent arg0) {
                }

                @Override
                public void windowDeiconified(WindowEvent arg0) {
                }

                @Override
                public void windowDeactivated(WindowEvent arg0) {
                }

                @Override
                public void windowClosing(WindowEvent arg0) {
                    if (AWTStyleDialog.this.metricsEditor != null) {
                        AWTStyleDialog.this.metricsEditor.dispose();
                    }
                }

                @Override
                public void windowClosed(WindowEvent arg0) {
                }

                @Override
                public void windowActivated(WindowEvent arg0) {
                }
            });
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public Font getFont() {
            if (this.fontChooser != null) {
                return this.fontChooser.getFont();
            }
            return null;
        }

        public Color getColor() {
            if (this.colorChooser != null) {
                return this.colorChooser.getColor();
            }
            return null;
        }

        public MetricsFormat getFormat() {
            if (this.metricsEditor != null) {
                return this.metricsEditor.format;
            }
            return null;
        }
    }

    public static class FontChooser
    extends JPanel {
        private static final long serialVersionUID = -53650261362110193L;
        private JLabel text;
        private JList fontList;
        private JComboBox sizeComboBox;
        private JCheckBox boldCheckBox;
        private JCheckBox italicCheckBox;
        private String[] fonts;
        private Font font;

        public FontChooser(String sampleText) {
            JPanel textPanel = new JPanel();
            this.text = new JLabel(sampleText);
            this.setLayout(new BorderLayout());
            textPanel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
            textPanel.add(this.text);
            textPanel.setMinimumSize(new Dimension(100, 100));
            textPanel.setPreferredSize(new Dimension(200, 100));
            this.add((Component)textPanel, "North");
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.fonts = ge.getAvailableFontFamilyNames();
            this.fontList = new JList<String>(this.fonts);
            this.fontList.setSelectionMode(0);
            this.fontList.setLayoutOrientation(0);
            this.fontList.setVisibleRowCount(-1);
            this.fontList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int index;
                    if (!e.getValueIsAdjusting() && (index = FontChooser.this.fontList.getSelectedIndex()) != -1) {
                        FontChooser.this.selectFont(index);
                    }
                }
            });
            this.fontList.setCellRenderer(new FontListRenderer());
            JScrollPane listScrollPane = new JScrollPane(this.fontList);
            listScrollPane.setPreferredSize(new Dimension(400, 200));
            this.add((Component)listScrollPane, "Center");
            JPanel controlPanel = new JPanel();
            this.add((Component)controlPanel, "South");
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FontChooser.this.selectFont(FontChooser.this.fontList.getSelectedIndex());
                }
            };
            Integer[] sizes = new Integer[]{4, 6, 7, 8, 9, 10, 11, 12, 14, 18, 20, 22, 24, 36, 40, 48, 56, 64, 72, 144};
            this.sizeComboBox = new JComboBox<Integer>(sizes);
            this.sizeComboBox.addActionListener(listener);
            this.sizeComboBox.setSelectedIndex(7);
            controlPanel.add(new JLabel("Size: "));
            controlPanel.add(this.sizeComboBox);
            this.boldCheckBox = new JCheckBox("Bold");
            this.boldCheckBox.addActionListener(listener);
            controlPanel.add(this.boldCheckBox);
            this.italicCheckBox = new JCheckBox("Italic");
            this.italicCheckBox.addActionListener(listener);
            controlPanel.add(this.italicCheckBox);
            this.fontList.setSelectedIndex(0);
        }

        private void selectFont(int index) {
            if (index < 0) {
                return;
            }
            String name = this.fonts[index];
            Integer size = (Integer)this.sizeComboBox.getSelectedItem();
            int style = 0;
            if (this.boldCheckBox.isSelected()) {
                style |= 1;
            }
            if (this.italicCheckBox.isSelected()) {
                style |= 2;
            }
            this.font = new Font(name, style, size);
            this.text.setFont(this.font);
        }

        @Override
        public Font getFont() {
            return this.font;
        }

        public void setCurrentFont(Font font) {
            int index = -1;
            int i = 0;
            while (i < this.fonts.length) {
                if (this.fonts[i].equals(font.getFamily())) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                return;
            }
            this.fontList.setSelectedIndex(index);
            this.fontList.scrollRectToVisible(this.fontList.getCellBounds(index, index));
            this.boldCheckBox.setSelected((font.getStyle() & 1) > 0);
            this.italicCheckBox.setSelected((font.getStyle() & 2) > 0);
            this.sizeComboBox.setSelectedItem(font.getSize());
        }

        public class FontListRenderer
        extends JLabel
        implements ListCellRenderer {
            private static final long serialVersionUID = 1237633327794383545L;

            public FontListRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(2);
                this.setVerticalAlignment(0);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                String text = (String)value;
                this.setText(text);
                this.setFont(new Font(text, 0, 16));
                return this;
            }
        }
    }

    public static class MetricsEditor
    extends JPanel {
        private static final long serialVersionUID = 3781280603509654789L;
        private JTextField valueTestField;
        private JTextField valuePresentationField;
        private JTextField formatNameField;
        private JTextField formatPatternField;
        private MetricsFormat format;
        private MetricsFormatList formatList;
        private double formatValue;
        private JTable formatTable;
        private MetricsTableModel tableModel;

        public MetricsEditor() {
            this.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            this.valueTestField = new JTextField();
            this.valuePresentationField = new JTextField();
            this.formatNameField = new JTextField();
            this.formatPatternField = new JTextField();
            JPanel labelPanel = new JPanel(new GridLayout(0, 1));
            JPanel fieldPanel = new JPanel(new GridLayout(0, 1));
            panel.add((Component)labelPanel, "West");
            panel.add((Component)fieldPanel, "Center");
            labelPanel.add(new JLabel("Value test:"));
            fieldPanel.add(this.valueTestField);
            labelPanel.add(new JLabel("Value presentation:"));
            fieldPanel.add(this.valuePresentationField);
            labelPanel.add(new JLabel("Format name:"));
            fieldPanel.add(this.formatNameField);
            labelPanel.add(new JLabel("Format pattern:"));
            fieldPanel.add(this.formatPatternField);
            this.add((Component)panel, "North");
            JPanel listPanel = new JPanel();
            this.add((Component)listPanel, "Center");
            JTable table = this.createFormatTable();
            JScrollPane scrollPane = new JScrollPane(table);
            table.setFillsViewportHeight(true);
            listPanel.add(scrollPane);
            JPanel controlPanel = new JPanel();
            this.add((Component)controlPanel, "South");
            controlPanel.setLayout(new FlowLayout(0));
            JButton addTemplateButton = new JButton("Add Format Template");
            addTemplateButton.setToolTipText("Add current format to templates");
            controlPanel.add(addTemplateButton);
            addTemplateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MetricsEditor.this.addTemplate();
                }
            });
            JButton removeTemplateButton = new JButton("Remove Template");
            removeTemplateButton.setToolTipText("Remove selected template");
            controlPanel.add(removeTemplateButton);
            removeTemplateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MetricsEditor.this.removeTemplate();
                }
            });
            JButton updateTemplateButton = new JButton("Update Template");
            updateTemplateButton.setToolTipText("Update selected template using current format");
            controlPanel.add(updateTemplateButton);
            updateTemplateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MetricsEditor.this.updateTemplate();
                }
            });
            JButton newFormatButton = new JButton("New Format");
            newFormatButton.setToolTipText("Create a new Format");
            controlPanel.add(newFormatButton);
            newFormatButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MetricsEditor.this.newFormat();
                }
            });
            this.valuePresentationField.setEditable(false);
            ActionListener l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetricsEditor.this.updateValues();
                }
            };
            this.valueTestField.addActionListener(l);
            this.formatPatternField.addActionListener(l);
            this.valueTestField.setText("123456.789");
            this.formatPatternField.setText("%s");
            this.updateValues();
        }

        private void addTemplate() {
            MetricsFormat format = this.createMetricsFormatFromFields();
            try {
                this.formatList.addFormat(format);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void updateTemplate() {
            int index = this.formatTable.getSelectedRow();
            if (index == -1) {
                return;
            }
            MetricsFormat format = this.createMetricsFormatFromFields();
            try {
                this.formatList.replaceFormatWith(this.formatList.getFormats()[index], format);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void removeTemplate() {
            int index = this.formatTable.getSelectedRow();
            if (index == -1) {
                return;
            }
            try {
                this.formatList.removeFormat(this.formatList.getFormats()[index]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void newFormat() {
            this.format = null;
            this.formatNameField.setText("New format");
            this.formatPatternField.setText("%s");
            this.updateValues();
        }

        private JTable createFormatTable() {
            this.formatList = MetricsFormatList.getList();
            this.tableModel = new MetricsTableModel(this.formatList);
            this.formatTable = new JTable(this.tableModel);
            this.formatTable.doLayout();
            this.formatTable.setSelectionMode(0);
            this.formatTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    int index = MetricsEditor.this.formatTable.getSelectionModel().getMinSelectionIndex();
                    if (index == -1) {
                        return;
                    }
                    MetricsEditor.this.setMetricsFormat(MetricsEditor.this.formatList.getFormats()[index]);
                }
            });
            return this.formatTable;
        }

        private void updateValues() {
            String value = this.valueTestField.getText();
            if (value == null || value.length() == 0) {
                return;
            }
            Double d = null;
            try {
                d = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                this.valuePresentationField.setText("Value test is not a number");
                return;
            }
            this.formatValue = d;
            MetricsFormat format = null;
            try {
                format = this.createMetricsFormatFromFields();
            }
            catch (Exception e) {
                this.valuePresentationField.setText("Format pattern is not correct " + e.getMessage());
            }
            if (format == null) {
                return;
            }
            this.setMetricsFormat(format);
            this.tableModel.setFormatValue(this.formatValue);
        }

        private MetricsFormat createMetricsFormatFromFields() {
            if (this.formatPatternField.getText().length() == 0) {
                return null;
            }
            return new MetricsFormat(this.formatPatternField.getText(), 1.0, this.formatNameField.getText());
        }

        public void setMetricsFormat(MetricsFormat format) {
            this.format = format;
            try {
                this.valuePresentationField.setText(format.formatValue(this.formatValue));
            }
            catch (Exception e) {
                this.valuePresentationField.setText("Format error: " + e.getMessage());
            }
            this.formatNameField.setText(format.getName());
            this.formatPatternField.setText(format.getPattern());
        }

        public void dispose() {
            this.tableModel.dispose();
        }

        private class MetricsTableModel
        implements TableModel,
        MetricsFormatListListener {
            private String[] columnNames = new String[]{"Name", "Format", "Value"};
            private MetricsFormatList formatList;
            private double formatValue = 0.0;
            private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

            public MetricsTableModel(MetricsFormatList formatList) {
                this.formatList = formatList;
                this.formatList.addListener((MetricsFormatListListener)this);
            }

            public void setFormatValue(double value) {
                this.formatValue = value;
                this.fireChanged();
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                MetricsFormat format = this.formatList.getFormats()[rowIndex];
                if (columnIndex == 0) {
                    return format.getName();
                }
                if (columnIndex == 1) {
                    return format.getPattern();
                }
                if (columnIndex == 2) {
                    return format.formatValue(this.formatValue);
                }
                throw new IndexOutOfBoundsException("There is no column " + columnIndex);
            }

            @Override
            public int getRowCount() {
                return this.formatList.getFormats().length;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return this.columnNames[columnIndex];
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
                this.listeners.add(l);
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
                this.listeners.remove(l);
            }

            public void onListChanged(MetricsFormatList sender) {
                this.fireChanged();
            }

            private void fireChanged() {
                for (TableModelListener l : this.listeners) {
                    l.tableChanged(new TableModelEvent(this));
                }
            }

            public void dispose() {
                this.formatList.removeListener((MetricsFormatListListener)this);
            }
        }
    }
}

