/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.HashMap;
import java.util.UUID;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.browsing.ui.platform.PropertyPageView;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class DuplicatePinnedViewHandler
extends AbstractHandler {
    private static final String PIN_SELECTION_COMMAND = "org.simantics.modeling.ui.pinSelection";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart originalPart = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        if (!(originalPart instanceof PropertyPageView)) {
            return null;
        }
        PropertyPageView originalPropertyView = (PropertyPageView)originalPart;
        try {
            ISelection originalSelection = originalPropertyView.getLastSelection();
            String id = String.valueOf(originalPart.getSite().getId()) + "Pinned:" + UUID.randomUUID().toString();
            PropertyPageView newPart = (PropertyPageView)WorkbenchUtils.activateView((String)id);
            newPart.selectionChanged(originalPart, originalSelection);
            newPart.pinWorkbenchSelection(true);
            ICommandService commandService = (ICommandService)newPart.getViewSite().getService(ICommandService.class);
            HashMap<String, IWorkbenchPartSite> filter = new HashMap<String, IWorkbenchPartSite>();
            filter.put("org.eclipse.ui.part.IWorkbenchPartSite", newPart.getSite());
            commandService.refreshElements(PIN_SELECTION_COMMAND, filter);
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
        return null;
    }
}

