/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.actions.AssignSymbolGroupsDialog;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class AssignSymbolGroup
implements ActionFactory {
    private static final SymbolGroup[] NO_SYMBOL_GROUPS = new SymbolGroup[0];

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource symbol = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                AssignSymbolGroup.this.assignGroups(Collections.singletonList(symbol));
            }
        };
    }

    private static Resource getCommonModel(final Collection<Resource> symbols) {
        try {
            return (Resource)Simantics.sync((ReadInterface)new UniqueRead<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    return AssignSymbolGroup.getPossibleIndexRoot(graph, symbols);
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }

    private static Resource getPossibleIndexRoot(ReadGraph g, Collection<Resource> symbols) throws DatabaseException {
        Resource model = null;
        for (Resource symbol : symbols) {
            Resource m = AssignSymbolGroup.getIndexRootOf(g, symbol);
            if (m == null) {
                return null;
            }
            if (model == null) {
                model = m;
                continue;
            }
            if (model.equals(m)) continue;
            return null;
        }
        return model;
    }

    private static Resource getIndexRootOf(ReadGraph g, Resource symbol) throws DatabaseException {
        return (Resource)g.syncRequest((Read)new PossibleIndexRoot(symbol));
    }

    private static SymbolGroup[] getSymbolGroups(final Collection<Resource> symbols) {
        try {
            return (SymbolGroup[])Simantics.getSession().syncRequest((Read)new Read<SymbolGroup[]>(){

                public SymbolGroup[] perform(ReadGraph g) throws DatabaseException {
                    return AssignSymbolGroup.getSymbolGroups(g, symbols);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return NO_SYMBOL_GROUPS;
        }
    }

    private static SymbolGroup[] getSymbolGroups(ReadGraph g, Collection<Resource> symbols) throws DatabaseException {
        Resource model = AssignSymbolGroup.getPossibleIndexRoot(g, symbols);
        if (model == null) {
            return NO_SYMBOL_GROUPS;
        }
        ArrayList<SymbolGroup> result = new ArrayList<SymbolGroup>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        for (Resource library : (Collection)g.syncRequest((Read)new ObjectsWithType(model, L0.ConsistsOf, DIA.SymbolReferenceLibrary))) {
            Tristate selected = AssignSymbolGroup.getLibrarySelectionState(g, library, symbols, DIA);
            selected = selected != null ? selected : Tristate.NONE;
            result.add(new SymbolGroup(library, NameUtils.getSafeLabel((ReadGraph)g, (Resource)library), selected, selected));
        }
        Collections.sort(result);
        return result.toArray(new SymbolGroup[result.size()]);
    }

    protected static Tristate getLibrarySelectionState(ReadGraph graph, Resource library, Collection<Resource> symbols, DiagramResource DIA) throws DatabaseException {
        Tristate selected = null;
        for (Resource symbol : symbols) {
            selected = Tristate.add(selected, graph.hasStatement(library, DIA.HasSymbol, symbol));
        }
        return selected != null ? selected : Tristate.NONE;
    }

    private static SymbolGroup[] selectedElements(SymbolGroup[] symbolGroups) {
        int count = 0;
        SymbolGroup[] symbolGroupArray = symbolGroups;
        int n = symbolGroups.length;
        int n2 = 0;
        while (n2 < n) {
            SymbolGroup g = symbolGroupArray[n2];
            if (g.selected != Tristate.NONE) {
                ++count;
            }
            ++n2;
        }
        SymbolGroup[] result = new SymbolGroup[count];
        count = 0;
        SymbolGroup[] symbolGroupArray2 = symbolGroups;
        int n3 = symbolGroups.length;
        n = 0;
        while (n < n3) {
            SymbolGroup g = symbolGroupArray2[n];
            if (g.selected != Tristate.NONE) {
                result[count++] = g;
            }
            ++n;
        }
        return result;
    }

    public void assignGroups(final Collection<Resource> symbols) {
        if (symbols.isEmpty()) {
            return;
        }
        final Resource model = AssignSymbolGroup.getCommonModel(symbols);
        if (model == null) {
            ShowMessage.showInformation((String)"Same Model Required", (String)"All the selected symbols must be from within the same model.");
            return;
        }
        final AtomicReference<SymbolGroup[]> groups = new AtomicReference<SymbolGroup[]>(AssignSymbolGroup.getSymbolGroups(symbols));
        StringBuilder message = new StringBuilder();
        message.append("Select symbol groups the selected ");
        if (symbols.size() > 1) {
            message.append(symbols.size()).append(" symbols are shown in.");
        } else {
            message.append("symbol is shown in.");
        }
        AssignSymbolGroupsDialog dialog = new AssignSymbolGroupsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), groups.get(), new ContentProviderImpl(), (ILabelProvider)new LabelProviderImpl(), new CheckStateProviderImpl(), message.toString()){

            @Override
            protected void checkStateChanged(Object[] elements, boolean checked) {
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object _g = objectArray[n2];
                    SymbolGroup g = (SymbolGroup)_g;
                    g.selected = checked ? Tristate.ALL : Tristate.NONE;
                    this.listViewer.refresh();
                    ++n2;
                }
            }

            @Override
            protected void newAction() {
                SymbolGroup newGroup = AssignSymbolGroup.newSymbolGroup(this.getShell(), model, (SymbolGroup[])this.inputElement);
                if (newGroup != null) {
                    newGroup.selected = Tristate.ALL;
                    Object[] newGroups = (SymbolGroup[])this.inputElement;
                    newGroups = Arrays.copyOf(newGroups, newGroups.length + 1);
                    newGroups[newGroups.length - 1] = newGroup;
                    Arrays.sort(newGroups);
                    this.listViewer.setInput((Object)newGroups);
                    this.inputElement = newGroups;
                    groups.set(newGroups);
                }
            }

            @Override
            protected void deleteAction(Object[] array) {
                Object[] groupsToRemove = (SymbolGroup[])Arrays.copyOf(array, array.length, SymbolGroup[].class);
                if (AssignSymbolGroup.this.removeSymbolGroups(this.getShell(), (SymbolGroup[])groupsToRemove)) {
                    this.listViewer.remove(groupsToRemove);
                    HashSet<Object> removedGroups = new HashSet<Object>();
                    Object[] objectArray = groupsToRemove;
                    int n = groupsToRemove.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object removed = objectArray[n2];
                        removedGroups.add(removed);
                        ++n2;
                    }
                    ArrayList<SymbolGroup> newGroups = new ArrayList<SymbolGroup>(((SymbolGroup[])groups.get()).length);
                    SymbolGroup[] symbolGroupArray = (SymbolGroup[])groups.get();
                    int n3 = symbolGroupArray.length;
                    n = 0;
                    while (n < n3) {
                        SymbolGroup old = symbolGroupArray[n];
                        if (!removedGroups.contains(old)) {
                            newGroups.add(old);
                        }
                        ++n;
                    }
                    groups.set(newGroups.toArray(NO_SYMBOL_GROUPS));
                }
            }
        };
        dialog.setTitle("Symbol Group Assignments");
        dialog.setInitialSelections(AssignSymbolGroup.selectedElements(groups.get()));
        if (dialog.open() == 0) {
            final ArrayList<SymbolGroup> added = new ArrayList<SymbolGroup>();
            final ArrayList<SymbolGroup> removed = new ArrayList<SymbolGroup>();
            SymbolGroup[] symbolGroupArray = groups.get();
            int n = symbolGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                SymbolGroup g = symbolGroupArray[n2];
                if (g.selected != g.originallySelected && g.selected == Tristate.ALL) {
                    added.add(g);
                }
                if (g.selected != g.originallySelected && g.selected == Tristate.NONE) {
                    removed.add(g);
                }
                ++n2;
            }
            if (!added.isEmpty() || !removed.isEmpty()) {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
                        for (Resource symbol : symbols) {
                            for (SymbolGroup group : added) {
                                g.claim(group.resource, DIA.HasSymbol, symbol);
                            }
                            for (SymbolGroup group : removed) {
                                g.deny(group.resource, DIA.HasSymbol, symbol);
                            }
                        }
                    }
                });
            }
        }
    }

    private static SymbolGroup newSymbolGroup(Shell shell, Resource model, final SymbolGroup[] oldGroups) {
        InputDialog dialog = new InputDialog(shell, "New Symbol Group", "Write the name of the new symbol group.", "NewSymbolGroup", new IInputValidator(){

            public String isValid(String newText) {
                if ((newText = newText.trim()).isEmpty()) {
                    return "The name must be non-empty.";
                }
                SymbolGroup[] symbolGroupArray = oldGroups;
                int n = oldGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    SymbolGroup g = symbolGroupArray[n2];
                    if (newText.equals(g.name)) {
                        return "A symbol group with that name already exists.";
                    }
                    ++n2;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            String name = dialog.getValue();
            try {
                NewSymbolGroupRequest request = new NewSymbolGroupRequest(name, model);
                Simantics.getSession().syncRequest((Write)request);
                return request.getSymbolGroup();
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
                return null;
            }
        }
        return null;
    }

    private boolean removeSymbolGroups(Shell shell, final SymbolGroup[] groups) {
        if (groups.length == 0) {
            return false;
        }
        String message = groups.length == 1 ? "Are you sure you want to remove symbol group '" + groups[0].name + "' ?" : "Are you sure you want to remove " + groups.length + " symbol groups?";
        MessageDialog dialog = new MessageDialog(shell, "Confirm removal", null, message, 3, new String[]{"OK", "Cancel"}, 0);
        if (dialog.open() == 0) {
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SymbolGroup[] symbolGroupArray = groups;
                    int n = groups.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SymbolGroup group = symbolGroupArray[n2];
                        graph.deny(group.resource);
                        ++n2;
                    }
                }
            });
            return true;
        }
        return false;
    }

    private static class CheckStateProviderImpl
    implements ICheckStateProvider {
        private CheckStateProviderImpl() {
        }

        public boolean isChecked(Object element) {
            return ((SymbolGroup)element).selected != Tristate.NONE;
        }

        public boolean isGrayed(Object element) {
            return ((SymbolGroup)element).selected == Tristate.SOME;
        }
    }

    private static class ContentProviderImpl
    implements IStructuredContentProvider {
        private ContentProviderImpl() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    private static class LabelProviderImpl
    extends LabelProvider {
        private LabelProviderImpl() {
        }

        public String getText(Object element) {
            return ((SymbolGroup)element).name;
        }
    }

    private static class NewSymbolGroupRequest
    extends WriteRequest {
        String name;
        Resource model;
        Resource symbolGroup;

        public NewSymbolGroupRequest(String name, Resource model) {
            this.name = name;
            this.model = model;
        }

        public void perform(WriteGraph g) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
            this.symbolGroup = g.newResource();
            g.claim(this.symbolGroup, L0.PartOf, this.model);
            g.claim(this.symbolGroup, L0.InstanceOf, DIA.SymbolReferenceLibrary);
            g.claimLiteral(this.symbolGroup, L0.HasName, (Object)this.name);
        }

        SymbolGroup getSymbolGroup() {
            if (this.symbolGroup == null) {
                return null;
            }
            return new SymbolGroup(this.symbolGroup, this.name, Tristate.NONE, Tristate.NONE);
        }
    }

    private static class SymbolGroup
    implements Comparable<SymbolGroup> {
        Resource resource;
        String name;
        Tristate originallySelected;
        Tristate selected;

        public SymbolGroup(Resource resource, String name, Tristate originallySelected, Tristate selected) {
            this.resource = resource;
            this.name = name;
            this.originallySelected = originallySelected;
            this.selected = selected;
        }

        @Override
        public int compareTo(SymbolGroup o) {
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)this.name, (Object)o.name);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[name=" + this.name + ", originally selected=" + (Object)((Object)this.originallySelected) + ", selected=" + (Object)((Object)this.selected) + "]";
        }
    }

    static enum Tristate {
        NONE,
        SOME,
        ALL;


        public static Tristate add(Tristate current, boolean next) {
            if (current == null) {
                return next ? ALL : NONE;
            }
            switch (current) {
                case ALL: {
                    return next ? ALL : SOME;
                }
                case SOME: {
                    return next ? SOME : SOME;
                }
                case NONE: {
                    return next ? SOME : NONE;
                }
            }
            return NONE;
        }
    }
}

