/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.deprecated;

import org.simantics.db.exception.ValueTypeMismatchException;

public enum ValueType {
    NoValue,
    BooleanValue,
    ByteValue,
    IntegerValue,
    LongValue,
    FloatValue,
    DoubleValue,
    StringValue;


    public boolean hasVariableSizeElements() {
        return this.compareTo(StringValue) == 0;
    }

    public static ValueType convert(Object obj) throws ValueTypeMismatchException {
        if (obj == null) {
            return NoValue;
        }
        if (obj.getClass() == boolean[].class) {
            return BooleanValue;
        }
        if (obj.getClass() == byte[].class) {
            return ByteValue;
        }
        if (obj.getClass() == int[].class) {
            return IntegerValue;
        }
        if (obj.getClass() == long[].class) {
            return LongValue;
        }
        if (obj.getClass() == float[].class) {
            return FloatValue;
        }
        if (obj.getClass() == double[].class) {
            return DoubleValue;
        }
        if (obj.getClass() == String[].class) {
            return StringValue;
        }
        throw new ValueTypeMismatchException("Unrecognized value class: " + obj.getClass().getName());
    }

    public byte getBits() {
        return (byte)(this.ordinal() & 7);
    }

    public static ValueType convert(byte b) {
        switch (b & 7) {
            case 0: {
                return NoValue;
            }
            case 1: {
                return BooleanValue;
            }
            case 2: {
                return ByteValue;
            }
            case 3: {
                return IntegerValue;
            }
            case 4: {
                return LongValue;
            }
            case 5: {
                return FloatValue;
            }
            case 6: {
                return DoubleValue;
            }
            case 7: {
                return StringValue;
            }
        }
        throw new Error("This was supposed to be unreachable code.");
    }
}

