/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.strings.AlphanumComparator;

public class VersionMap
extends MapList<String, NamedResource> {
    public NamedResource getNewest(ReadGraph graph, String baseName) {
        List versions = this.getValues(baseName);
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        NamedResource result = (NamedResource)versions.get(0);
        int i = 1;
        while (i < versions.size()) {
            NamedResource version = (NamedResource)versions.get(i);
            if (AlphanumComparator.COMPARATOR.compare((Object)version.getName(), (Object)result) > 0) {
                result = version;
            }
            ++i;
        }
        return result;
    }

    public Collection<NamedResource> getOlderOrEqualVersions(ReadGraph graph, Resource artifact) throws DatabaseException {
        String baseName = Versions.getBaseName(graph, artifact);
        String version = Versions.getVersion(graph, artifact);
        List versions = this.getValues(baseName);
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        ArrayList<NamedResource> result = new ArrayList<NamedResource>();
        for (NamedResource nr : versions) {
            if (AlphanumComparator.COMPARATOR.compare((Object)nr.getName(), (Object)version) > 0) continue;
            result.add(nr);
        }
        return result;
    }

    public Collection<NamedResource> getNewerOrEqualVersions(ReadGraph graph, Resource artifact) throws DatabaseException {
        String baseName = Versions.getBaseName(graph, artifact);
        String version = Versions.getVersion(graph, artifact);
        List versions = this.getValues(baseName);
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        ArrayList<NamedResource> result = new ArrayList<NamedResource>();
        for (NamedResource nr : versions) {
            if (AlphanumComparator.COMPARATOR.compare((Object)nr.getName(), (Object)version) < 0) continue;
            result.add(nr);
        }
        return result;
    }

    public boolean contains(String baseName, String version) {
        List versions = this.getValues(baseName);
        if (versions == null || versions.isEmpty()) {
            return false;
        }
        for (NamedResource nr : versions) {
            if (!nr.getName().equals(version)) continue;
            return true;
        }
        return false;
    }
}

