/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class URIStringUtils {
    public static final char NAMESPACE_PATH_SEPARATOR = '/';
    public static final char NAMESPACE_LOCAL_SEPARATOR = '#';
    private static final int HTTP_POSITION = "http://".length();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset ASCII = Charset.forName("US-ASCII");

    private static int assertSingleSeparatorPosition(String uri) {
        int sharpIndex = uri.indexOf(35);
        if (sharpIndex == -1) {
            throw new IllegalArgumentException("URI '" + uri + "' does not contain any '" + '#' + "' separator characters");
        }
        int nextSharpIndex = uri.indexOf(35, sharpIndex + 1);
        if (nextSharpIndex != -1) {
            throw new IllegalArgumentException("URI '" + uri + "' contains multiple '" + '#' + "' separator characters");
        }
        return sharpIndex;
    }

    private static int singleSeparatorPosition(String uri) {
        int sharpIndex = uri.indexOf(35);
        if (sharpIndex == -1) {
            return -1;
        }
        int nextSharpIndex = uri.indexOf(35, sharpIndex + 1);
        if (nextSharpIndex != -1) {
            return -1;
        }
        return sharpIndex;
    }

    public static String getNamespace(String uri) {
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        int separatorIndex = URIStringUtils.assertSingleSeparatorPosition(uri);
        return uri.substring(0, separatorIndex);
    }

    public static String getRVIParent(String uri) {
        int childSeparator = uri.lastIndexOf(47);
        int propertySeparator = uri.lastIndexOf(35);
        int separator = Math.max(childSeparator, propertySeparator);
        return uri.substring(0, separator);
    }

    public static String getLocalName(String uri) {
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        int separatorIndex = URIStringUtils.assertSingleSeparatorPosition(uri);
        return uri.substring(separatorIndex + 1);
    }

    public static String escapeName(String name) {
        char[] chars = name.toCharArray();
        boolean modified = false;
        int i = 0;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                chars[i] = 95;
                modified = true;
            }
            ++i;
        }
        if (modified) {
            return new String(chars);
        }
        return name;
    }

    public static String[] splitURI(String uri) {
        int nextPathSeparator = uri.lastIndexOf(47);
        if (nextPathSeparator == -1) {
            return null;
        }
        if (nextPathSeparator == HTTP_POSITION - 1) {
            if (uri.startsWith("http://")) {
                return new String[]{"http://", uri.substring(HTTP_POSITION, uri.length())};
            }
            return null;
        }
        return new String[]{uri.substring(0, nextPathSeparator), uri.substring(nextPathSeparator + 1, uri.length())};
    }

    public static List<String> splitURISCL(String uri) {
        String[] result = URIStringUtils.splitURI(uri);
        ArrayList<String> list = new ArrayList<String>(result.length);
        String[] stringArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(s);
            ++n2;
        }
        return list;
    }

    public static String[] trySplitNamespaceAndLocalName(String uri) {
        String[] stringArray;
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        int separatorIndex = URIStringUtils.singleSeparatorPosition(uri);
        if (separatorIndex == -1) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = uri.substring(0, separatorIndex);
            stringArray = stringArray2;
            stringArray2[1] = uri.substring(separatorIndex + 1);
        }
        return stringArray;
    }

    public static String[] splitNamespaceAndLocalName(String uri) {
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        int separatorIndex = URIStringUtils.assertSingleSeparatorPosition(uri);
        return new String[]{uri.substring(0, separatorIndex), uri.substring(separatorIndex + 1)};
    }

    public static String escapeURI(String localName) {
        if (localName == null) {
            throw new NullPointerException("null local name");
        }
        String result = URIStringUtils.encode(localName);
        return result;
    }

    public static String appendURINamespace(String namespace, String suffix) {
        return new StringBuffer(namespace.length() + 1 + suffix.length()).append(namespace).append('/').append(suffix).toString();
    }

    public static String makeURI(String namespace, String localName) {
        String escapedLocalName = URIStringUtils.escapeURI(localName);
        return new StringBuffer(namespace.length() + 1 + escapedLocalName.length()).append(namespace).append('#').append(escapedLocalName).toString();
    }

    public static String escape(String unicode) {
        return URIStringUtils.encode(unicode);
    }

    private static String encode(String unicode) {
        boolean needsEscapes = URIStringUtils.needsEscaping(unicode);
        if (!needsEscapes) {
            return unicode;
        }
        byte[] utf8 = unicode.getBytes(UTF8);
        byte[] rsltAscii = new byte[utf8.length * 6];
        int in = 0;
        int out = 0;
        while (in < utf8.length) {
            switch (utf8[in]) {
                case 33: 
                case 36: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 61: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 93: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 126: {
                    rsltAscii[out] = utf8[in];
                    ++out;
                    ++in;
                    break;
                }
                case 32: {
                    rsltAscii[out++] = 37;
                    rsltAscii[out++] = 50;
                    rsltAscii[out++] = 48;
                    ++in;
                    break;
                }
                default: {
                    rsltAscii[out++] = 37;
                    int c = utf8[in] & 0xFF;
                    rsltAscii[out++] = URIStringUtils.hexEncode(c / 16);
                    rsltAscii[out++] = URIStringUtils.hexEncode(c % 16);
                    ++in;
                }
            }
        }
        return new String(rsltAscii, 0, out, ASCII);
    }

    private static boolean needsEscaping(String unicode) {
        int len = unicode.length();
        int i = 0;
        while (i < len) {
            switch (unicode.charAt(i)) {
                case '!': 
                case '$': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '~': {
                    break;
                }
                case ' ': 
                case '#': 
                case '%': 
                case '&': 
                case '/': {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean needsUnescaping(String unicode) {
        return unicode.indexOf(37) > -1;
    }

    public static String unescape(String uri) {
        try {
            if (!URIStringUtils.needsUnescaping(uri)) {
                return uri;
            }
            byte[] ascii = uri.getBytes("US-ASCII");
            byte[] utf8 = new byte[ascii.length];
            int in = 0;
            int out = 0;
            while (in < ascii.length) {
                if (ascii[in] == 37) {
                    utf8[out++] = (byte)(URIStringUtils.hexDecode(ascii[++in]) * 16 | URIStringUtils.hexDecode(ascii[in + 1]));
                    in += 2;
                    continue;
                }
                utf8[out++] = ascii[in++];
            }
            return new String(utf8, 0, out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("The JVM is required to support UTF-8 and US-ASCII encodings.");
        }
        catch (ArrayIndexOutOfBoundsException ee) {
            throw new IllegalArgumentException("Incomplete Hex escape sequence in " + uri);
        }
    }

    private static byte hexEncode(int i) {
        if (i < 10) {
            return (byte)(48 + i);
        }
        return (byte)(65 + i - 10);
    }

    private static int hexDecode(byte b) {
        switch (b) {
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return (b & 0xFF) - 97 + 10;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return b - 65 + 10;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return b - 48;
            }
        }
        throw new IllegalArgumentException("Bad Hex escape character: " + (b & 0xFF));
    }

    public static void main(String[] args) {
        String s = "http://www.vtt.fi%2FSome- %25 Namespace/Jotain";
        System.out.println(String.format("escape+unescape: %s -> %s -> %s", s, URIStringUtils.escape(s), URIStringUtils.unescape(URIStringUtils.escape(s))));
        s = "http://www.vtt.fi%2FPSK";
        System.out.println(String.format("unescape: %s -> %s", s, URIStringUtils.unescape(s)));
        s = "http://www.vtt.fi%2FSome-Namespace/Jotain / Muuta";
        System.out.println(String.format("escape: %s -> %s", s, URIStringUtils.escape(s)));
        s = "Jotain / Muuta";
        System.out.println(String.format("escape: %s -> %s", s, URIStringUtils.escape(s)));
        System.out.println("escapeURI: " + URIStringUtils.escapeURI("foo/bar/org%2Fnet"));
        System.out.println("escapeURI('...#...'): " + URIStringUtils.escapeURI("foo/bar#org%2Fnet"));
        s = URIStringUtils.makeURI("http://foo.bar.com/foo/bar", "baz/guuk/org%2Fnet");
        System.out.println("escapeURI: " + s);
        System.out.println("getNamespace: " + URIStringUtils.getNamespace(s));
        System.out.println("getLocalName: " + URIStringUtils.getLocalName(s));
        URIStringUtils.testEscape("/", "%2F");
        URIStringUtils.testEscape("#", "%23");
        URIStringUtils.testEscape("%", "%25");
        URIStringUtils.testEscape("%01", "%2501");
        URIStringUtils.testEscape("%GG", "%25GG");
    }

    private static void testEscape(String unescaped, String expectedEscaped) {
        String esc = URIStringUtils.escape(unescaped);
        String unesc = URIStringUtils.unescape(esc);
        System.out.format("escape('%s')='%s', unescape('%s')='%s'\n", unescaped, esc, esc, unesc);
        if (!esc.equals(expectedEscaped)) {
            throw new AssertionError((Object)("escape('" + unescaped + "') was expected to return '" + expectedEscaped + "' but returned '" + esc + "'"));
        }
        if (!unesc.equals(unescaped)) {
            throw new AssertionError((Object)("unescape(escape('" + unescaped + "'))=unescape(" + esc + ") was expected to return '" + unescaped + "' but returned '" + unesc + "'"));
        }
    }
}

