/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.Arrays;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.utils.datastructures.Callback;

public class TagUtil {
    private final String virtualGraphId;
    private final String tagURI;
    private final boolean tag;

    public static void execute(Session session, String virtualGraphId, String tagURI, boolean tag, Resource ... resources) {
        TagUtil.execute(session, virtualGraphId, tagURI, tag, Arrays.asList(resources));
    }

    public static void execute(Session session, String virtualGraphId, String tagURI, boolean tag, List<Resource> resources) {
        new TagUtil(virtualGraphId, tagURI, tag).execute(session, resources);
    }

    public TagUtil(String virtualGraphId, String tagURI, boolean tag) {
        this.virtualGraphId = virtualGraphId;
        this.tagURI = tagURI;
        this.tag = tag;
    }

    public void execute(Session session, Resource ... resources) {
        this.execute(session, Arrays.asList(resources));
    }

    public void execute(Session session, final List<Resource> resources) {
        VirtualGraph vg = this.virtualGraphId == null ? null : ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent(this.virtualGraphId);
        session.asyncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                TagUtil.this.processSelection(graph, resources);
            }
        }, (Callback)new Callback<DatabaseException>(){

            public void run(DatabaseException e) {
                if (e != null) {
                    TagUtil.this.handleError(e);
                }
            }
        });
    }

    public void syncExecute(Session session, Resource ... resources) throws DatabaseException {
        this.syncExecute(session, Arrays.asList(resources));
    }

    public void syncExecute(Session session, final List<Resource> resources) throws DatabaseException {
        VirtualGraph vg = this.virtualGraphId == null ? null : ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent(this.virtualGraphId);
        session.syncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                TagUtil.this.processSelection(graph, resources);
            }
        });
    }

    protected void processSelection(WriteGraph graph, List<Resource> resources) throws DatabaseException {
        if (this.tagURI == null) {
            return;
        }
        final Resource tr = graph.getResource(this.tagURI);
        for (final Resource r : resources) {
            if (this.tag) {
                if (this.virtualGraphId == null) {
                    VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
                    VirtualGraph vg = vgs.getGraph((ReadGraph)graph, r);
                    if (vg != null) {
                        graph.sync((WriteInterface)new WriteRequest(vg){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                graph.claim(r, tr, r);
                            }
                        });
                        continue;
                    }
                    graph.claim(r, tr, r);
                    continue;
                }
                graph.claim(r, tr, r);
                continue;
            }
            graph.deny(r, tr, r);
        }
    }

    protected void handleError(DatabaseException e) {
        Logger.defaultLogError(e);
    }
}

