/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IsParent;
import org.simantics.db.common.request.PossibleOwner;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.collections.CollectionUtils;

public class CommonDBUtils {
    public static boolean isParent(ReadGraph graph, Resource possibleParent, Resource possibleChild) throws DatabaseException {
        return (Boolean)graph.sync((ReadInterface)new IsParent(possibleParent, possibleChild));
    }

    public static Resource parent(ReadGraph graph, Resource child) throws DatabaseException {
        return graph.getSingleObject(child, Layer0.getInstance((ReadGraph)graph).PartOf);
    }

    public static String possibleRelatedString(ReadGraph graph, Resource subject, Resource relation) throws DatabaseException {
        return (String)graph.getRelatedValue(subject, relation, (Binding)Bindings.STRING);
    }

    public static Integer possibleRelatedInteger(ReadGraph graph, Resource subject, Resource relation) throws DatabaseException {
        return (Integer)graph.getRelatedValue(subject, relation, (Binding)Bindings.INTEGER);
    }

    public static Resource getPossibleOwner(ReadGraph graph, Resource resource) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new PossibleOwner(resource));
    }

    public static Resource commonAncestor(ReadGraph graph, Resource r1, Resource r2) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (r1.equals(r2)) {
            return r1;
        }
        HashSet<Resource> visited = new HashSet<Resource>();
        visited.add(r1);
        visited.add(r2);
        do {
            if (r1 != null) {
                if ((r1 = graph.getPossibleObject(r1, L0.IsOwnedBy)) == null || visited.add(r1)) continue;
                return r1;
            }
            if (r2 != null) continue;
            return null;
        } while (r2 == null || (r2 = graph.getPossibleObject(r2, L0.IsOwnedBy)) == null || visited.add(r2));
        return r2;
    }

    public static Resource getNearestOwner(ReadGraph graph, Collection<Resource> resources) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<Resource> direct = new ArrayList<Resource>();
        HashSet<Resource> owners = new HashSet<Resource>();
        for (Resource r : resources) {
            Resource directOwner = graph.getPossibleObject(r, L0.IsOwnedBy);
            if (directOwner != null) {
                direct.add(directOwner);
                continue;
            }
            for (Statement stm : graph.getStatements(r, L0.IsWeaklyRelatedTo)) {
                Resource inverse = graph.getPossibleInverse(stm.getPredicate());
                if (inverse == null || !graph.isSubrelationOf(inverse, L0.IsRelatedTo) || r.equals(stm.getObject())) continue;
                owners.add(stm.getObject());
            }
        }
        if (!direct.isEmpty()) {
            Resource common = (Resource)direct.get(0);
            int i = 1;
            while (i < direct.size()) {
                Resource other = (Resource)direct.get(i);
                if ((common = CommonDBUtils.commonAncestor(graph, common, other)) == null) break;
                ++i;
            }
            if (common != null) {
                owners.add(common);
            }
        }
        if (!Collections.disjoint(owners, resources)) {
            System.err.println("Overlapping owners:");
            for (Resource r : resources) {
                System.err.println("-resource " + NameUtils.getSafeName(graph, r, true));
            }
            for (Resource r : owners) {
                System.err.println("-owner " + NameUtils.getSafeName(graph, r, true));
            }
            return null;
        }
        if (owners.size() == 1) {
            return (Resource)owners.iterator().next();
        }
        if (owners.size() == 0) {
            return null;
        }
        return CommonDBUtils.getNearestOwner(graph, owners);
    }

    public static Resource getClusterSetForNewResource(ReadGraph graph, Resource ... resources) throws DatabaseException {
        if (resources.length == 1) {
            return CommonDBUtils.getClusterSetForNewResource(graph, resources[0]);
        }
        Resource owner = CommonDBUtils.getNearestOwner(graph, CollectionUtils.toList((Object[])resources));
        if (owner == null) {
            return null;
        }
        return CommonDBUtils.getClusterSetForNewResource(graph, owner, new HashSet<Resource>());
    }

    public static Resource getClusterSetForNewResource(ReadGraph graph, Collection<Resource> resources) throws DatabaseException {
        if (resources.size() == 1) {
            return CommonDBUtils.getClusterSetForNewResource(graph, resources.iterator().next());
        }
        Resource owner = CommonDBUtils.getNearestOwner(graph, resources);
        return CommonDBUtils.getClusterSetForNewResource(graph, owner, new HashSet<Resource>());
    }

    public static Resource getClusterSetForNewResource(ReadGraph graph, Resource resource, Set<Resource> visited) throws DatabaseException {
        ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        if (cs.isClusterSet(resource)) {
            return resource;
        }
        Resource owner = CommonDBUtils.getPossibleOwner(graph, resource);
        if (owner == null || owner == resource) {
            return null;
        }
        if (!visited.add(owner)) {
            return null;
        }
        return CommonDBUtils.getClusterSetForNewResource(graph, owner, visited);
    }

    public static Resource getClusterSetForNewResource(ReadGraph graph, Resource r) throws DatabaseException {
        return CommonDBUtils.getClusterSetForNewResource(graph, r, new HashSet<Resource>());
    }

    public static void selectClusterSet(WriteGraph graph, Collection<Resource> resources) throws DatabaseException {
        Resource clusterSet = CommonDBUtils.getClusterSetForNewResource((ReadGraph)graph, resources);
        if (clusterSet == null) {
            clusterSet = graph.getRootLibrary();
        }
        graph.setClusterSet4NewResource(clusterSet);
    }

    public static void selectClusterSet(WriteGraph graph, Resource ... resources) throws DatabaseException {
        Resource clusterSet = CommonDBUtils.getClusterSetForNewResource((ReadGraph)graph, resources);
        if (clusterSet == null) {
            clusterSet = graph.getRootLibrary();
        }
        graph.setClusterSet4NewResource(clusterSet);
    }

    public static void selectClusterSet(WriteGraph graph, Resource resource) throws DatabaseException {
        Resource clusterSet = CommonDBUtils.getClusterSetForNewResource((ReadGraph)graph, resource);
        if (clusterSet == null) {
            clusterSet = graph.getRootLibrary();
        }
        graph.setClusterSet4NewResource(clusterSet);
    }
}

