/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.uri;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class UnescapedChildMapOfResource
extends ResourceRead<Map<String, Resource>> {
    public UnescapedChildMapOfResource(Resource resource) {
        super(resource);
    }

    public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection objects = graph.getObjects(this.resource, L0.ConsistsOf);
        THashMap result = new THashMap(objects.size());
        for (Resource r : objects) {
            String name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
            if (name == null || result.put((Object)name, (Object)r) == null) continue;
            System.err.println(this + ": The database contains siblings with the same name " + name + " (resource=$" + this.resource.getResourceId() + ").");
        }
        return result;
    }
}

