/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.uri;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class ResourceToURI
extends ResourceRead<String> {
    public ResourceToURI(Resource resource) {
        super(resource);
    }

    public String perform(ReadGraph graph) throws DatabaseException {
        if (this.resource.equals(graph.getRootLibrary())) {
            return "http:/";
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(this.resource, L0.HasName, (Binding)Bindings.STRING);
        if (name == null) {
            throw new AssumptionException("resource " + this.resource + " does not have a name");
        }
        String escapedName = URIStringUtils.escape(name);
        Resource parent = graph.getPossibleObject(this.resource, L0.PartOf);
        if (parent == null) {
            throw new AssumptionException("resource " + this.resource + " does not have a parent");
        }
        String parentURI = (String)graph.syncRequest((Read)new ResourceToURI(parent));
        if (parentURI == null) {
            throw new AssumptionException("parent resource " + parent + " has no URI");
        }
        return String.valueOf(parentURI) + "/" + escapedName;
    }
}

