/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.uri;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class ResourceToPossibleURI
extends ResourceRead<String> {
    public ResourceToPossibleURI(Resource resource) {
        super(resource);
    }

    public String perform(ReadGraph g) throws DatabaseException {
        if (g.getRootLibrary().equals(this.resource)) {
            return "http:/";
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        String name = (String)g.getPossibleRelatedValue(this.resource, L0.HasName, (Binding)Bindings.STRING);
        if (name == null) {
            return null;
        }
        String escapedName = URIStringUtils.escape(name);
        Resource parent = g.getPossibleObject(this.resource, L0.PartOf);
        if (parent == null) {
            return null;
        }
        String parentURI = (String)g.syncRequest((Read)new ResourceToPossibleURI(parent));
        if (parentURI == null) {
            return null;
        }
        return String.valueOf(parentURI) + "/" + escapedName;
    }
}

