/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ResourceSet;
import org.simantics.db.exception.DatabaseException;

public class ResourceSetGraph {
    public final List<ResourceSetGraph> references;
    public final Resource resource;
    public final Map<ResourceSet, Set<Resource>> cache = new HashMap<ResourceSet, Set<Resource>>();

    public ResourceSetGraph(Resource result) {
        this.resource = result;
        this.references = new ArrayList<ResourceSetGraph>();
    }

    private Set<Resource> probe(ReadGraph graph, ResourceSet types) {
        return this.cache.get(types);
    }

    private Set<Resource> resolve(ReadGraph graph, ResourceSet types, Set<ResourceSetGraph> visited) throws DatabaseException {
        if (visited != null && !visited.add(this)) {
            return Collections.emptySet();
        }
        Set<Resource> cached = this.cache.get(types);
        if (cached != null) {
            return cached;
        }
        boolean includeThis = !types.disjoint(graph.getTypes(this.resource));
        Set<Resource> allRefs = null;
        for (ResourceSetGraph ref : this.references) {
            Set<Resource> refs = ref.probe(graph, types);
            if (refs == null) {
                if (visited == null) {
                    visited = new HashSet<ResourceSetGraph>();
                    visited.add(this);
                }
                refs = ref.resolve(graph, types, visited);
            }
            if (refs.isEmpty()) continue;
            if (allRefs == null) {
                allRefs = new HashSet<Resource>();
            }
            allRefs.addAll(refs);
        }
        Set<Resource> result = Collections.emptySet();
        if (allRefs != null) {
            if (allRefs.size() == 1) {
                if (includeThis) {
                    allRefs.add(this.resource);
                    result = allRefs.size() == 1 ? Collections.singleton(allRefs.iterator().next()) : allRefs;
                } else {
                    result = Collections.singleton((Resource)allRefs.iterator().next());
                }
            } else {
                if (includeThis) {
                    allRefs.add(this.resource);
                }
                result = allRefs;
            }
        } else if (includeThis) {
            result = Collections.singleton(this.resource);
        }
        this.cache.put(types, result);
        return result;
    }

    public Set<Resource> resolve(ReadGraph graph, ResourceSet types) throws DatabaseException {
        Set<Object> result = this.resolve(graph, types, null);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }
}

