/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;

public abstract class ResourceRead<T>
implements Read<T>,
ReadInterface<T> {
    protected final Resource resource;

    public int hashCode() {
        return this.resource.hashCode() + this.classHash();
    }

    private int classHash() {
        return 31 * this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResourceRead r = (ResourceRead)object;
        return this.resource.equals(r.resource);
    }

    public ResourceRead(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource.");
        }
        this.resource = resource;
    }

    public void request(AsyncRequestProcessor processor, AsyncProcedure<T> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, Procedure<T> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, SyncProcedure<T> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, AsyncListener<T> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, Listener<T> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, SyncListener<T> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public T request(RequestProcessor processor) throws DatabaseException {
        return (T)processor.syncRequest((Read)this);
    }
}

