/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.RealizationType;
import org.simantics.db.common.request.ResourceAsyncRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

public class RealizedChildSetRequest
extends ResourceAsyncRead<Collection<Resource>> {
    public RealizedChildSetRequest(Resource resource) {
        super(resource);
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<Collection<Resource>> procedure) {
        final Layer0 l0 = (Layer0)graph.getService(Layer0.class);
        final Layer0X L0X = (Layer0X)graph.getService(Layer0X.class);
        final AtomicInteger ready = new AtomicInteger(2);
        final ConcurrentSkipListSet result = new ConcurrentSkipListSet();
        graph.forEachObject(this.resource, l0.ConsistsOf, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

            public void finished(AsyncReadGraph graph) {
                if (ready.decrementAndGet() == 0) {
                    procedure.execute(graph, (Object)result);
                }
            }

            public void execute(AsyncReadGraph graph, final Resource comp) {
                ready.incrementAndGet();
                graph.forPossibleRelatedValue(comp, l0.HasName, (AsyncProcedure)new AsyncProcedure<String>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        Logger.defaultLogError(throwable);
                    }

                    public void execute(AsyncReadGraph graph, String name) {
                        if (name != null) {
                            graph.asyncRequest((AsyncRead)new RealizationType(comp, L0X.Realization), (AsyncProcedure)new AsyncProcedure<Resource>(){

                                public void exception(AsyncReadGraph graph, Throwable throwable) {
                                    Logger.defaultLogError(throwable);
                                }

                                public void execute(AsyncReadGraph graph, Resource type) {
                                    result.add(comp);
                                    if (ready.decrementAndGet() == 0) {
                                        procedure.execute(graph, (Object)result);
                                    }
                                }
                            });
                        } else if (ready.decrementAndGet() == 0) {
                            procedure.execute(graph, (Object)result);
                        }
                    }
                });
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                Logger.defaultLogError(throwable);
            }
        });
        graph.forEachObject(this.resource, L0X.IsRealized, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){

            public void finished(AsyncReadGraph graph) {
                if (ready.decrementAndGet() == 0) {
                    procedure.execute(graph, (Object)result);
                }
            }

            public void execute(AsyncReadGraph graph, final Resource comp) {
                ready.incrementAndGet();
                graph.forPossibleRelatedValue(comp, l0.HasName, (AsyncProcedure)new AsyncProcedure<String>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        Logger.defaultLogError(throwable);
                    }

                    public void execute(AsyncReadGraph graph, String name) {
                        if (name != null) {
                            graph.asyncRequest((AsyncRead)new RealizationType(comp, L0X.Realization), (AsyncProcedure)new AsyncProcedure<Resource>(){

                                public void exception(AsyncReadGraph graph, Throwable throwable) {
                                    Logger.defaultLogError(throwable);
                                }

                                public void execute(AsyncReadGraph graph, Resource type) {
                                    result.add(comp);
                                    if (ready.decrementAndGet() == 0) {
                                        procedure.execute(graph, (Object)result);
                                    }
                                }
                            });
                        } else if (ready.decrementAndGet() == 0) {
                            procedure.execute(graph, (Object)result);
                        }
                    }
                });
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                Logger.defaultLogError(throwable);
            }
        });
    }
}

