/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import java.util.HashMap;
import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.ResourceSetGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class DependentInstances3
extends ResourceRead<ResourceSetGraph> {
    private static final boolean DEBUG = false;
    private static ThreadLocal<HashMap<DependentInstances3, ResourceSetGraph>> workArea = new ThreadLocal();

    public DependentInstances3(Resource resource) {
        super(resource);
    }

    private static ResourceSetGraph test(DependentInstances3 instance) {
        HashMap<DependentInstances3, ResourceSetGraph> set = workArea.get();
        if (set == null) {
            return null;
        }
        return set.get(instance);
    }

    private void register(ResourceSetGraph result) {
        HashMap<DependentInstances3, ResourceSetGraph> set = workArea.get();
        if (set == null) {
            set = new HashMap();
            workArea.set(set);
        }
        set.put(this, result);
    }

    private void unregister() {
        HashMap<DependentInstances3, ResourceSetGraph> set = workArea.get();
        if (set != null) {
            set.remove(this);
        }
    }

    public ResourceSetGraph perform(ReadGraph graph) throws DatabaseException {
        if (this.resource.equals(graph.getRootLibrary())) {
            return new ResourceSetGraph(this.resource);
        }
        ResourceSetGraph result = DependentInstances3.test(this);
        if (result != null) {
            return result;
        }
        result = new ResourceSetGraph(this.resource);
        this.register(result);
        HashSet<Resource> objects = new HashSet<Resource>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Statement dep : graph.getStatements(this.resource, L0.IsDependencyOf)) {
            if (graph.isSubrelationOf(dep.getPredicate(), L0.HasPrevious)) continue;
            objects.add(dep.getObject());
        }
        for (Resource object : objects) {
            DependentInstances3 query = new DependentInstances3(object);
            ResourceSetGraph instances = DependentInstances3.test(query);
            if (instances == null) {
                instances = (ResourceSetGraph)graph.syncRequest((Read)query);
            }
            result.references.add(instances);
        }
        this.unregister();
        return result;
    }
}

