/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.changeset;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.simantics.db.ChangeSet;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.utils.ReflectionUtils;

public abstract class GenericChangeListener<Request, Result>
implements ChangeListener {
    private final Constructor<Read<Result>> constructor;

    public GenericChangeListener() {
        try {
            Class clazz = ReflectionUtils.getSingleParameterTypeExtending(this.getClass());
            this.constructor = clazz.getConstructor(ChangeSet.class);
            return;
        }
        catch (SecurityException e) {
            Logger.defaultLogError(e);
        }
        catch (NoSuchMethodException e) {
            Logger.defaultLogError(e);
        }
        throw new IllegalArgumentException();
    }

    public final void graphChanged(ChangeEvent e) throws DatabaseException {
        try {
            if (!this.preEventRequest()) {
                return;
            }
            Object event = e.getGraph().syncRequest(this.constructor.newInstance(e.getChanges()), TransientCacheListener.instance());
            this.onEvent(e.getGraph(), e.getMetadataI(), event);
        }
        catch (IllegalArgumentException e1) {
            Logger.defaultLogError(e1);
        }
        catch (InstantiationException e1) {
            Logger.defaultLogError(e1);
        }
        catch (IllegalAccessException e1) {
            Logger.defaultLogError(e1);
        }
        catch (InvocationTargetException e1) {
            Logger.defaultLogError(e1);
        }
    }

    public boolean preEventRequest() {
        return true;
    }

    public abstract void onEvent(ReadGraph var1, MetadataI var2, Result var3) throws DatabaseException;
}

