/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

public class CommandMetadata
implements Metadata {
    public static final boolean DEBUG = false;
    private static final Binding BINDING = Bindings.getBindingUnchecked(CommandMetadata.class);
    private static final Serializer SERIALIZER = Bindings.getSerializerUnchecked((Binding)BINDING);
    public List<Command> commands;

    public byte[] serialise(Session session) {
        try {
            return SERIALIZER.serialize((Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static CommandMetadata deserialise(Session session, byte[] input) {
        if (input == null) {
            CommandMetadata metadata = new CommandMetadata();
            metadata.commands = new ArrayList<Command>();
            return metadata;
        }
        try {
            return (CommandMetadata)SERIALIZER.deserialize(input);
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public CommandMetadata add(Command command) {
        this.commands.add(command);
        return this;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public static void add(WriteGraph graph, long modelId, String command) throws DatabaseException {
        graph.addMetadata((Metadata)((CommandMetadata)graph.getMetadata(CommandMetadata.class)).add(new Command(modelId, command)));
    }

    public static class Command {
        public long modelId;
        public String command;

        public Command() {
        }

        public Command(long modelId, String command) {
            this.modelId = modelId;
            this.command = command;
        }
    }
}

