/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphfile.hack;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graphfile.hack.GraphFile;
import org.simantics.graphfile.hack.GraphFileEditorInput;

public class GraphFileEditorInputFactory
implements IElementFactory {
    private static final String ID_FACTORY = "org.simantics.graphfile.hack.GraphFileEditorInputFactory";
    private static final String TAG_RESOURCE_ID = "id";

    public IAdaptable createElement(IMemento memento) {
        String sid = memento.getString(TAG_RESOURCE_ID);
        if (sid == null) {
            return null;
        }
        final long id = Long.parseLong(sid);
        Resource fileResource = null;
        try {
            fileResource = (Resource)Simantics.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                    try {
                        Resource r = support.getResource(id);
                        return r;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }
        catch (DatabaseException e) {
            return null;
        }
        if (fileResource == null) {
            return null;
        }
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        GraphFile file = new GraphFile(fileResource, ws);
        return new GraphFileEditorInput(file);
    }

    public static String getFactoryId() {
        return ID_FACTORY;
    }

    public static void saveState(IMemento memento, GraphFileEditorInput input) {
        GraphFile file = (GraphFile)input.getFile();
        memento.putString(TAG_RESOURCE_ID, Long.toString(file.getFileResource().getResourceId()));
    }
}

