/*
 * Decompiled with CFR 0.152.
 */
package com.tools.logging;

import com.tools.logging.LoggedStatus;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;

public class PluginLogAppender
extends AppenderSkeleton {
    private ILog pluginLog;

    void setLog(ILog pluginLog) {
        this.pluginLog = pluginLog;
    }

    public void append(LoggingEvent event) {
        ThrowableInformation info;
        if (this.layout == null) {
            this.errorHandler.error("Missing layout for appender " + this.name, null, 5);
            return;
        }
        String text = this.layout.format(event);
        Throwable thrown = null;
        if (this.layout.ignoresThrowable() && (info = event.getThrowableInformation()) != null) {
            thrown = info.getThrowable();
        }
        Level level = event.getLevel();
        int severity = 0;
        if (level.toInt() >= 40000) {
            severity = 4;
        } else if (level.toInt() >= 30000) {
            severity = 2;
        } else if (level.toInt() >= 10000) {
            severity = 1;
        }
        this.pluginLog.log((IStatus)new LoggedStatus(severity, this.pluginLog.getBundle().getSymbolicName(), level.toInt(), text, thrown));
    }

    public void close() {
        this.closed = true;
    }

    public boolean requiresLayout() {
        return true;
    }
}

