/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui.editor;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.graph.GraphUI;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.ui.Spreadsheet;
import org.simantics.spreadsheet.ui.editor.ExcelLink;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.ResourceEditorPart2;
import org.simantics.utils.ui.LayoutUtils;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;

public class SpreadsheetEditor2
extends ResourceEditorPart2 {
    public static final boolean EXCEL = true;
    public static final String EDITOR_ID = "org.simantics.spreadsheet.ui.editor2";
    private Spreadsheet spreadsheet;
    private final ActiveSelectionProvider selectionProvider = new ActiveSelectionProvider();
    private ExcelLink excelLink;
    private GraphUI ui;

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        this.ui = new GraphUI((RequestProcessor)this.getSession());
        try {
            Variable variable = (Variable)this.getSession().syncRequest((Read)new Read<Variable>(){

                public Variable perform(ReadGraph graph) throws DatabaseException {
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    String modelURI = graph.getURI(SpreadsheetEditor2.this.getResourceInput2().getModel(graph));
                    RVI rvi = RVI.fromResourceFormat((RequestProcessor)graph, (String)SpreadsheetEditor2.this.getResourceInput2().getRVI());
                    Resource model = graph.getResource(modelURI);
                    if (rvi == null) {
                        Variable base = (Variable)graph.adapt(model, Variable.class);
                        return base;
                    }
                    SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                    SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                    Instances query = (Instances)graph.adapt(SHEET.Run, Instances.class);
                    Collection runs = query.find(graph, model);
                    if (runs.size() == 1) {
                        Variable base = Variables.getVariable((ReadGraph)graph, (Resource)((Resource)runs.iterator().next()));
                        return rvi.resolve(graph, base);
                    }
                    Resource realization = graph.getPossibleObject(model, SIMU.HasConfiguration);
                    Variable base = (Variable)graph.adapt(realization, Variable.class);
                    return rvi.resolve(graph, base);
                }
            });
            String uri = (String)this.getSession().syncRequest((Read)new UnaryRead<Variable, String>(variable){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return ((Variable)this.parameter).getURI(graph);
                }
            });
            String sheetName = (String)this.getSession().syncRequest((Read)new UnaryRead<Variable, String>(variable){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return (String)((Variable)this.parameter).getPropertyValue(graph, "HasName");
                }
            });
            Resource sheet = (Resource)this.getSession().syncRequest((Read)new UnaryRead<Variable, Resource>(variable){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    return ((Variable)this.parameter).getRepresents(graph);
                }
            });
            String bookName = (String)this.getSession().syncRequest((Read)new UnaryRead<Variable, String>(variable){

                public String perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Resource model = Variables.getModel((ReadGraph)graph, (Variable)((Variable)this.parameter));
                    String name = (String)graph.getRelatedValue(model, L0.HasName, (Binding)Bindings.STRING);
                    Variable book = (Variable)((Variable)this.parameter).getPropertyValue(graph, "Parent");
                    return String.valueOf(name) + "-" + book.getPropertyValue(graph, "HasName");
                }
            });
            Resource book = (Resource)this.getSession().syncRequest((Read)new UnaryRead<Variable, Resource>(variable){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Resource model = Variables.getModel((ReadGraph)graph, (Variable)((Variable)this.parameter));
                    Variable book = (Variable)((Variable)this.parameter).getPropertyValue(graph, "Parent");
                    return (Resource)book.getPropertyValue(graph, "Represents");
                }
            });
            this.spreadsheet = new Spreadsheet(parent, 0, (Adaptable)this.ui, this.selectionProvider);
            this.spreadsheet.setBackground(parent.getDisplay().getSystemColor(1));
            this.excelLink = new ExcelLink(this.getSession(), sheet, this.spreadsheet.getClientModel(), book, bookName, sheetName, uri);
            this.ui.load(variable, this.spreadsheet.getClientInterface());
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return;
        }
        this.spreadsheet.setLayoutData(new GridData(4, 4, true, true));
        this.spreadsheet.defaultInitializeUI();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        IContextService contexts = (IContextService)this.getSite().getService(IContextService.class);
        contexts.activateContext("org.simantics.spreadsheet.ui.context");
    }

    public void setFocus() {
        if (this.spreadsheet != null) {
            this.spreadsheet.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertyPage.class) {
            return new StandardPropertyPage(this.getSite(), Collections.singleton("http://www.simantics.org/Spreadsheet-1.2/BrowseContext"));
        }
        if (adapter == GraphUI.class) {
            return this.ui;
        }
        if (adapter == Spreadsheet.class) {
            return this.getSpreadsheet();
        }
        return null;
    }

    public void dispose() {
        this.excelLink.dispose();
        super.dispose();
    }
}

