/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ui.SpreadsheetCellEditor;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

class TextTableCellEditor
extends DefaultCellEditor
implements SpreadsheetCellEditor {
    final int row;
    final int column;
    final CellEditor editor;
    final String initial;
    private static final long serialVersionUID = 8039248821751464832L;
    JTextField ftf;

    public TextTableCellEditor(int row, int column, String initial, CellEditor editor) {
        super(new JTextField());
        assert (editor != null);
        this.row = row;
        this.column = column;
        this.initial = initial == null ? "" : initial;
        this.editor = editor;
        this.ftf = (JTextField)this.getComponent();
        this.ftf.setHorizontalAlignment(11);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JTextField ftf = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setText(this.initial);
        ftf.selectAll();
        ftf.setFont(ftf.getFont().deriveFont(AffineTransform.getScaleInstance(0.8, 0.8)));
        return ftf;
    }

    @Override
    public Object getCellEditorValue() {
        JTextField ftf = (JTextField)this.getComponent();
        return ftf.getText();
    }

    protected boolean userSaysRevert() {
        Toolkit.getDefaultToolkit().beep();
        this.ftf.selectAll();
        Object[] options = new Object[]{"Edit", "Revert"};
        int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.ftf), "The value must be an integer between You can either continue editing or revert to the last valid value.", "Invalid Text Entered", 0, 0, null, options, options[1]);
        if (answer == 1) {
            this.ftf.setText(this.ftf.getText());
            return true;
        }
        return false;
    }

    @Override
    public void commit() {
        this.editor.edit(null, SpreadsheetUtils.cellName((int)this.row, (int)this.column), Variant.ofInstance((Object)((String)this.getCellEditorValue())));
    }
}

