/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;

public class TableRowResizer
extends MouseInputAdapter {
    public static Cursor resizeCursor = Cursor.getPredefinedCursor(8);
    private int mouseYOffset;
    private int resizingRow;
    private Cursor otherCursor = resizeCursor;
    private JTable table;

    public TableRowResizer(JTable table) {
        this.table = table;
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
    }

    private int getResizingRow(Point p) {
        return this.getResizingRow(p, this.table.rowAtPoint(p));
    }

    private int getResizingRow(Point p, int row) {
        if (row == -1) {
            return -1;
        }
        int col = this.table.columnAtPoint(p);
        if (col == -1) {
            return -1;
        }
        Rectangle r = this.table.getCellRect(row, col, true);
        r.grow(0, -3);
        if (r.contains(p)) {
            return -1;
        }
        int midPoint = r.y + r.height / 2;
        int rowIndex = p.y < midPoint ? row - 1 : row;
        return rowIndex;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        this.resizingRow = this.getResizingRow(p);
        this.mouseYOffset = p.y - this.table.getRowHeight(this.resizingRow);
    }

    private void swapCursor() {
        Cursor tmp = this.table.getCursor();
        this.table.setCursor(this.otherCursor);
        this.otherCursor = tmp;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getResizingRow(e.getPoint()) >= 0 != (this.table.getCursor() == resizeCursor)) {
            this.swapCursor();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int newHeight;
        int mouseY = e.getY();
        if (this.resizingRow >= 0 && (newHeight = mouseY - this.mouseYOffset) > 0) {
            this.table.setRowHeight(this.resizingRow, newHeight);
            this.onResize(this.resizingRow, newHeight);
        }
    }

    public void onResize(int row, int height) {
    }
}

