/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.eclipse.core.runtime.Platform;
import org.simantics.common.color.Color;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.JScrollPaneSG;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.CellModifier;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.common.cell.Parsers;
import org.simantics.spreadsheet.common.cell.StringCellParser;
import org.simantics.spreadsheet.event.model.RemoveCellHandler;
import org.simantics.spreadsheet.ui.CellValue;
import org.simantics.spreadsheet.ui.ClientModelImpl;
import org.simantics.spreadsheet.ui.ClientTableModel;
import org.simantics.spreadsheet.ui.ColumnHeaderRenderer;
import org.simantics.spreadsheet.ui.DefaultLookup;
import org.simantics.spreadsheet.ui.DropTargetListener;
import org.simantics.spreadsheet.ui.ExcelAdapter;
import org.simantics.spreadsheet.ui.ExpressionTextListener;
import org.simantics.spreadsheet.ui.JFontChooser;
import org.simantics.spreadsheet.ui.RowHeaderRenderer;
import org.simantics.spreadsheet.ui.SelectionListener;
import org.simantics.spreadsheet.ui.SpreadsheetTable;
import org.simantics.spreadsheet.ui.TableRowResizer;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;

public class SpreadsheetModel {
    private final Adaptable serverInterface;
    private final ClientModel clientModel;
    private final ActiveSelectionProvider selectionProvider;
    protected Clipboard system;
    protected StringCellParser[] parsers = new StringCellParser[]{Parsers.COMMAND_PARSER, Parsers.EXPRESSION_PARSER, Parsers.TEXT_PARSER};
    private JTextField expression;
    private JButton foreground;
    private JButton background;
    private JButton font;
    private JButton align_left;
    private JButton align_hcenter;
    private JButton align_right;
    private JButton align_top;
    private JButton align_vcenter;
    private JButton align_bottom;
    private JComboBox borders;
    private ExpressionTextListener etl;
    private SpreadsheetTable table;
    private ExcelAdapter excel;
    private boolean columnMarginsDirty = false;

    public SpreadsheetModel(Adaptable serverInterface, ActiveSelectionProvider selectionProvider) {
        this.serverInterface = serverInterface;
        this.clientModel = new ClientModelImpl();
        this.selectionProvider = selectionProvider;
    }

    public ClientModel getClientModel() {
        return this.clientModel;
    }

    public SpreadsheetTable getTable() {
        return this.table;
    }

    public JComponent createComponent(INode node) {
        Properties props = (Properties)this.serverInterface.getAdapter(Properties.class);
        boolean addExpressionField = props == null || "true".equalsIgnoreCase(props.getProperty("sheet.expression.visible", "true"));
        JPanel panel = new JPanel(new BorderLayout());
        final DefaultListModel lm = new DefaultListModel(){
            private static final long serialVersionUID = 5246691801867533053L;

            @Override
            public Object getElementAt(int index) {
                Object result = super.getElementAt(index);
                if (result instanceof String) {
                    return result;
                }
                return "" + (index + 1);
            }
        };
        if (addExpressionField) {
            BufferedImage img2;
            this.foreground = new JButton();
            this.foreground.setToolTipText("Assign foreground color to selection");
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/paintbrush.png"));
                this.foreground.setIcon(new ImageIcon(img2));
            }
            catch (IOException img2) {
                // empty catch block
            }
            this.foreground.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    java.awt.Color c = JColorChooser.showDialog(SpreadsheetModel.this.foreground, "asd", Colors.awt((Color)Colors.rgb((double)0.0, (double)0.0, (double)0.0)));
                    RGB.Integer color = Colors.integerRGB((java.awt.Color)c);
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    int[] nArray = selectedColumns;
                    int n = selectedColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int col = nArray[n2];
                        int[] nArray2 = selectedRows;
                        int n3 = selectedRows.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int row = nArray2[n4];
                            String location = SpreadsheetUtils.cellName((int)row, (int)col);
                            editor.edit(null, location, "foreground", (Object)color, RGB.Integer.BINDING);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
            this.background = new JButton();
            this.background.setToolTipText("Assign background color to selection");
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/paintcan.png"));
                this.background.setIcon(new ImageIcon(img2));
            }
            catch (IOException img3) {
                // empty catch block
            }
            this.background.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    java.awt.Color c = JColorChooser.showDialog(SpreadsheetModel.this.background, "asd", Colors.awt((Color)Colors.rgb((double)0.0, (double)0.0, (double)0.0)));
                    RGB.Integer color = Colors.integerRGB((java.awt.Color)c);
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    int[] nArray = selectedColumns;
                    int n = selectedColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int col = nArray[n2];
                        int[] nArray2 = selectedRows;
                        int n3 = selectedRows.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int row = nArray2[n4];
                            String location = SpreadsheetUtils.cellName((int)row, (int)col);
                            editor.edit(null, location, "background", (Object)color, RGB.Integer.BINDING);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
            this.font = new JButton();
            this.font.setToolTipText("Assign font to selection");
            this.font.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFontChooser fontChooser = new JFontChooser();
                    int result = fontChooser.showDialog(SpreadsheetModel.this.font);
                    if (result == 0) {
                        java.awt.Font font = fontChooser.getSelectedFont();
                        System.out.println("Selected Font : " + font);
                        Font f = Fonts.fromAWT((java.awt.Font)font);
                        int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                        int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                        CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                        if (editor == null) {
                            return;
                        }
                        int[] nArray = selectedColumns;
                        int n = selectedColumns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int col = nArray[n2];
                            int[] nArray2 = selectedRows;
                            int n3 = selectedRows.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                int row = nArray2[n4];
                                String location = SpreadsheetUtils.cellName((int)row, (int)col);
                                editor.edit(null, location, "font", (Object)f, Font.BINDING);
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                }
            });
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/font.png"));
                this.font.setIcon(new ImageIcon(img2));
            }
            catch (IOException img4) {
                // empty catch block
            }
            this.align_left = new JButton();
            this.align_left.setToolTipText("Align selection to left");
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_left.png"));
                this.align_left.setIcon(new ImageIcon(img2));
            }
            catch (IOException img5) {
                // empty catch block
            }
            this.align_left.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    int[] nArray = selectedColumns;
                    int n = selectedColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int col = nArray[n2];
                        int[] nArray2 = selectedRows;
                        int n3 = selectedRows.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int row = nArray2[n4];
                            String location = SpreadsheetUtils.cellName((int)row, (int)col);
                            CellValue value = (CellValue)SpreadsheetModel.this.table.getValueAt(row, col);
                            int align = value != null ? value.align : 0;
                            align = (align & 0xC) + 0;
                            editor.edit(null, location, "align", (Object)align, (Binding)Bindings.INTEGER);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
            this.align_hcenter = new JButton();
            this.align_hcenter.setToolTipText("Align selection horizontally to center");
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_center.png"));
                this.align_hcenter.setIcon(new ImageIcon(img2));
            }
            catch (IOException img6) {
                // empty catch block
            }
            this.align_hcenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    int[] nArray = selectedColumns;
                    int n = selectedColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int col = nArray[n2];
                        int[] nArray2 = selectedRows;
                        int n3 = selectedRows.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int row = nArray2[n4];
                            String location = SpreadsheetUtils.cellName((int)row, (int)col);
                            CellValue value = (CellValue)SpreadsheetModel.this.table.getValueAt(row, col);
                            int align = value != null ? value.align : 0;
                            align = (align & 0xC) + 1;
                            editor.edit(null, location, "align", (Object)align, (Binding)Bindings.INTEGER);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
            this.align_right = new JButton();
            this.align_right.setToolTipText("Align selection to right");
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_right.png"));
                this.align_right.setIcon(new ImageIcon(img2));
            }
            catch (IOException img7) {
                // empty catch block
            }
            this.align_right.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    int[] nArray = selectedColumns;
                    int n = selectedColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int col = nArray[n2];
                        int[] nArray2 = selectedRows;
                        int n3 = selectedRows.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int row = nArray2[n4];
                            String location = SpreadsheetUtils.cellName((int)row, (int)col);
                            CellValue value = (CellValue)SpreadsheetModel.this.table.getValueAt(row, col);
                            int align = value != null ? value.align : 0;
                            align = (align & 0xC) + 2;
                            editor.edit(null, location, "align", (Object)align, (Binding)Bindings.INTEGER);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
            this.align_top = new JButton();
            this.align_top.setToolTipText("Align selection to top");
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_top.png"));
                this.align_top.setIcon(new ImageIcon(img2));
            }
            catch (IOException img8) {
                // empty catch block
            }
            this.align_top.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    int[] nArray = selectedColumns;
                    int n = selectedColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int col = nArray[n2];
                        int[] nArray2 = selectedRows;
                        int n3 = selectedRows.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int row = nArray2[n4];
                            String location = SpreadsheetUtils.cellName((int)row, (int)col);
                            CellValue value = (CellValue)SpreadsheetModel.this.table.getValueAt(row, col);
                            int align = value != null ? value.align : 0;
                            align = (align & 3) + 0;
                            editor.edit(null, location, "align", (Object)align, (Binding)Bindings.INTEGER);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
            this.align_vcenter = new JButton();
            this.align_vcenter.setToolTipText("Align selection vertically to center");
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_middle.png"));
                this.align_vcenter.setIcon(new ImageIcon(img2));
            }
            catch (IOException img9) {
                // empty catch block
            }
            this.align_vcenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    int[] nArray = selectedColumns;
                    int n = selectedColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int col = nArray[n2];
                        int[] nArray2 = selectedRows;
                        int n3 = selectedRows.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int row = nArray2[n4];
                            String location = SpreadsheetUtils.cellName((int)row, (int)col);
                            CellValue value = (CellValue)SpreadsheetModel.this.table.getValueAt(row, col);
                            int align = value != null ? value.align : 0;
                            align = (align & 3) + 4;
                            editor.edit(null, location, "align", (Object)align, (Binding)Bindings.INTEGER);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
            this.align_bottom = new JButton();
            this.align_bottom.setToolTipText("Align selection to bottom");
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_bottom.png"));
                this.align_bottom.setIcon(new ImageIcon(img2));
            }
            catch (IOException img10) {
                // empty catch block
            }
            this.align_bottom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    int[] nArray = selectedColumns;
                    int n = selectedColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int col = nArray[n2];
                        int[] nArray2 = selectedRows;
                        int n3 = selectedRows.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int row = nArray2[n4];
                            String location = SpreadsheetUtils.cellName((int)row, (int)col);
                            CellValue value = (CellValue)SpreadsheetModel.this.table.getValueAt(row, col);
                            int align = value != null ? value.align : 0;
                            align = (align & 3) + 8;
                            editor.edit(null, location, "align", (Object)align, (Binding)Bindings.INTEGER);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
            this.borders = new JComboBox();
            this.borders.addItem("No borders");
            this.borders.addItem("Bottom border");
            this.borders.addItem("Top border");
            this.borders.addItem("Left border");
            this.borders.addItem("Right border");
            this.borders.addActionListener(new ActionListener(){
                Map<String, Integer> work = new HashMap<String, Integer>();

                int getCurrent(String location, int row, int column) {
                    CellValue value = (CellValue)SpreadsheetModel.this.table.getValueAt(row, column);
                    int border = value != null ? value.border : 0;
                    this.work.put(location, border);
                    return border;
                }

                void setCurrent(String location, int border) {
                    this.work.put(location, border);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.work.clear();
                    int index = SpreadsheetModel.this.borders.getSelectedIndex();
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    int[] nArray = selectedColumns;
                    int n = selectedColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int col = nArray[n2];
                        int[] nArray2 = selectedRows;
                        int n3 = selectedRows.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String up;
                            String left;
                            int row = nArray2[n4];
                            String location = SpreadsheetUtils.cellName((int)row, (int)col);
                            if (index == 0) {
                                if (col > 0) {
                                    left = SpreadsheetUtils.cellName((int)row, (int)(col - 1));
                                    this.setCurrent(left, this.getCurrent(left, row, col - 1) & 2);
                                }
                                if (row > 0) {
                                    up = SpreadsheetUtils.cellName((int)(row - 1), (int)col);
                                    this.setCurrent(up, this.getCurrent(up, row - 1, col) & 1);
                                }
                                this.setCurrent(location, 0);
                            } else if (index == 1) {
                                this.setCurrent(location, this.getCurrent(location, row, col) | 2);
                            } else if (index == 2) {
                                if (row > 0) {
                                    up = SpreadsheetUtils.cellName((int)(row - 1), (int)col);
                                    this.setCurrent(up, this.getCurrent(up, row - 1, col) | 2);
                                }
                            } else if (index == 3) {
                                if (col > 0) {
                                    left = SpreadsheetUtils.cellName((int)row, (int)(col - 1));
                                    this.setCurrent(left, this.getCurrent(left, row, col - 1) | 1);
                                }
                            } else if (index == 4) {
                                this.setCurrent(location, this.getCurrent(location, row, col) | 1);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    for (Map.Entry<String, Integer> entry : this.work.entrySet()) {
                        String location = entry.getKey();
                        Integer border = entry.getValue();
                        editor.edit(null, location, "border", (Object)border, (Binding)Bindings.INTEGER);
                    }
                }
            });
            this.expression = new JTextField();
            this.etl = new ExpressionTextListener(this.expression, (CellEditor)this.serverInterface.getAdapter(CellEditor.class));
            this.expression.addFocusListener(this.etl);
            this.expression.addKeyListener(this.etl);
        }
        java.awt.Font font = new java.awt.Font("Courier", 0, 14);
        this.table = new SpreadsheetTable(node, (CellEditor)this.serverInterface.getAdapter(CellEditor.class), this.clientModel, lm){
            private static final long serialVersionUID = 4553572254034185984L;

            protected void mouseDragFinished() {
                CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                if (editor == null) {
                    return;
                }
                TableColumn column = SpreadsheetModel.this.table.getTableHeader().getResizingColumn();
                if (column == null) {
                    return;
                }
                int[] current = SpreadsheetModel.this.clientModel.getColumnWidths();
                if (column.getModelIndex() >= current.length) {
                    current = Arrays.copyOf(current, column.getModelIndex() + 1);
                }
                current[column.getModelIndex()] = column.getWidth();
                editor.edit(null, "Headers", "columnWidths", (Object)current, (Binding)Bindings.INT_ARRAY);
            }
        };
        ((ClientTableModel)this.table.getModel()).setTable(this.table);
        InputMap im = this.table.getInputMap(1);
        AbstractAction deleteAction = new AbstractAction(){
            private static final long serialVersionUID = 428343700053346645L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.out.println("deleteaction");
                RemoveCellHandler removeHandler = (RemoveCellHandler)SpreadsheetModel.this.serverInterface.getAdapter(RemoveCellHandler.class);
                int[] rowSelection = SpreadsheetModel.this.table.getSelectedRows();
                int[] columnSelection = SpreadsheetModel.this.table.getSelectedColumns();
                int i = 0;
                while (i < columnSelection.length) {
                    int j = 0;
                    while (j < rowSelection.length) {
                        int row = rowSelection[j];
                        int column = columnSelection[i];
                        System.out.println("deleteaction " + row + " " + column);
                        Object object = SpreadsheetModel.this.table.getValueAt(row, column);
                        ++j;
                    }
                    ++i;
                }
            }
        };
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        im.put(KeyStroke.getKeyStroke(127, 0), delete);
        this.table.getActionMap().put(im.get(KeyStroke.getKeyStroke(127, 0)), deleteAction);
        this.table.setFont(font);
        DropTarget dropTarget = new DropTarget((Component)((Object)this.table), new DropTargetListener((JTable)((Object)this.table), this.serverInterface));
        if (this.serverInterface != null) {
            this.excel = new ExcelAdapter((JTable)((Object)this.table), this.clientModel, this.serverInterface, this.parsers);
        }
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(true);
        final JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(40);
        rowHeader.setCellRenderer(new RowHeaderRenderer((JTable)((Object)this.table)));
        rowHeader.setBackground(DefaultLookup.GRAY);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int tableRows;
                int currentRows = rowHeader.getModel().getSize();
                if (currentRows != (tableRows = SpreadsheetModel.this.table.getModel().getRowCount())) {
                    lm.setSize(tableRows);
                }
            }
        });
        JScrollPaneSG scroll = new JScrollPaneSG((Component)((Object)this.table), node);
        scroll.setRowHeaderView(rowHeader);
        this.table.getParent().setBackground(DefaultLookup.GRAY);
        this.table.getTableHeader().setBackground(DefaultLookup.GRAY);
        rowHeader.getParent().setBackground(DefaultLookup.GRAY);
        scroll.getViewport().setBackground(DefaultLookup.GRAY);
        this.table.getTableHeader().setDefaultRenderer(new ColumnHeaderRenderer());
        scroll.setBackground(DefaultLookup.GRAY);
        if (this.selectionProvider != null) {
            SelectionListener listener = new SelectionListener((JTable)((Object)this.table), this.expression, this.etl, this.selectionProvider, this.serverInterface, this.clientModel);
            this.table.getSelectionModel().addListSelectionListener(listener);
            this.table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        }
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                SpreadsheetModel.this.columnMarginsDirty = true;
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }
        });
        new TableRowResizer((JTable)((Object)this.table)){

            @Override
            public void onResize(int row, int height) {
                CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                if (editor == null) {
                    return;
                }
                int[] current = SpreadsheetModel.this.clientModel.getRowHeights();
                if (row >= current.length) {
                    current = Arrays.copyOf(current, row + 1);
                }
                current[row] = height;
                editor.edit(null, "Headers", "rowHeights", (Object)current, (Binding)Bindings.INT_ARRAY);
                rowHeader.setCellRenderer(new RowHeaderRenderer((JTable)((Object)SpreadsheetModel.this.table)));
            }
        };
        if (addExpressionField) {
            JPanel tools = new JPanel(new GridBagLayout());
            panel.add((Component)tools, "First");
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.anchor = 17;
            tools.add((Component)this.font, c);
            c.gridx = 1;
            tools.add((Component)this.foreground, c);
            c.gridx = 2;
            tools.add((Component)this.background, c);
            c.gridx = 3;
            tools.add((Component)this.align_left, c);
            c.gridx = 4;
            tools.add((Component)this.align_hcenter, c);
            c.gridx = 5;
            tools.add((Component)this.align_right, c);
            c.gridx = 6;
            tools.add((Component)this.align_top, c);
            c.gridx = 7;
            tools.add((Component)this.align_vcenter, c);
            c.gridx = 8;
            tools.add((Component)this.align_bottom, c);
            c.gridx = 9;
            tools.add((Component)this.borders, c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 10;
            c.gridheight = 1;
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.fill = 2;
            tools.add((Component)this.expression, c);
        }
        panel.add((Component)scroll, "Center");
        return panel;
    }

    public CellModifier getClientInterface() {
        return this.clientModel;
    }
}

