/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.ComponentNode;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellModifier;
import org.simantics.spreadsheet.ui.SpreadsheetModel;

public class SheetNode
extends ComponentNode<JComponent>
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = -8212264868316567181L;
    private SpreadsheetModel sm;
    protected ActionListener actionListener = null;

    public void init(Adaptable serverInterface) {
        this.scale = true;
        this.sm = new SpreadsheetModel(serverInterface, null);
        this.component = this.sm.createComponent((INode)this);
        this.component.addFocusListener(this);
        super.init();
    }

    public CellModifier getModifier() {
        return this.sm.getClientInterface();
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    @INode.ServerSide
    public void actionPerformed(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
        if (this.container.getParent() != null) {
            this.container.getParent().requestFocusInWindow();
        }
    }

    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
        this.container.setBounds(0, 0, (int)bounds.getWidth(), (int)bounds.getHeight());
        this.container.setSize((int)bounds.getWidth(), (int)bounds.getHeight());
        this.container.validate();
    }

    public void render(Graphics2D g2d) {
        if (this.sm == null) {
            return;
        }
        if (this.sm.getTable() == null) {
            return;
        }
        this.container.validate();
        super.render(g2d);
    }
}

