/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.participant.PopulateSelectionDropParticipant;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.element.ElementHints;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.ui.SheetClass;
import org.simantics.spreadsheet.ui.SheetFactory;
import org.simantics.utils.ui.ISelectionUtils;

public class PopulateSheetDropParticipant
extends PopulateSelectionDropParticipant {
    public PopulateSheetDropParticipant(GraphToDiagramSynchronizer synchronizer) {
        super(synchronizer);
    }

    public List<ElementClassDragItem> getElements(Session session, IStructuredSelection selection) throws DatabaseException {
        final Resource resource = (Resource)ISelectionUtils.filterSingleSelection((Object)selection, Resource.class);
        if (resource == null) {
            return Collections.emptyList();
        }
        return (List)session.syncRequest((Read)new Read<List<ElementClassDragItem>>(){

            public List<ElementClassDragItem> perform(ReadGraph graph) throws DatabaseException {
                SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(resource, sr.Spreadsheet)) {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    ElementClassDragItem item = new ElementClassDragItem(SheetFactory.createSheetClass(sr.SpreadsheetElement));
                    item.getHintContext().setHint(SheetClass.KEY_SHEET, (Object)resource);
                    String rvi = "/" + URIStringUtils.escape((String)((String)graph.getPossibleRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING)));
                    item.getHintContext().setHint(SheetClass.KEY_RVI, (Object)rvi);
                    item.getHintContext().setHint(ElementHints.KEY_TRANSFORM, (Object)AffineTransform.getScaleInstance(1.0, 1.0));
                    return Collections.singletonList(item);
                }
                return Collections.emptyList();
            }
        });
    }
}

