/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class ExpressionTextListener
implements FocusListener,
KeyListener {
    private final JTextField text;
    private final CellEditor editor;
    String undoPoint = null;
    int currentRow;
    int currentColumn;

    public ExpressionTextListener(JTextField text, CellEditor editor) {
        this.text = text;
        this.editor = editor;
    }

    void setCell(String text, int row, int column) {
        this.text.setText(text);
        this.undoPoint = text;
        this.currentRow = row;
        this.currentColumn = column;
    }

    void apply() {
        if (this.undoPoint == null) {
            return;
        }
        String current = this.text.getText();
        if (current.equals(this.undoPoint)) {
            return;
        }
        if (this.currentRow == -1 || this.currentColumn == -1) {
            return;
        }
        this.editor.edit(null, SpreadsheetUtils.cellName((int)this.currentRow, (int)this.currentColumn), "content#expression", (Object)current, (Binding)Bindings.STRING);
        this.undoPoint = current;
    }

    void cancel() {
        if (this.undoPoint != null) {
            this.text.setText(this.undoPoint);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.apply();
        }
        if (e.getKeyCode() == 27) {
            this.cancel();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.apply();
    }
}

