/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import javax.swing.JTable;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ui.TextTableCellEditor;

public class DropTargetListener
implements java.awt.dnd.DropTargetListener {
    JTable table;
    Adaptable model;

    public DropTargetListener(JTable table, Adaptable model) {
        this.table = table;
        this.model = model;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable tr = dropTargetDropEvent.getTransferable();
        if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                String data = (String)tr.getTransferData(DataFlavor.stringFlavor);
                Point point = dropTargetDropEvent.getLocation();
                int row = this.table.rowAtPoint(point);
                int column = this.table.columnAtPoint(point);
                CellEditor e = (CellEditor)this.model.getAdapter(CellEditor.class);
                TextTableCellEditor editor = new TextTableCellEditor(row, column, "", e);
                editor.commit();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

