/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Color;
import java.awt.Font;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.table.DefaultTableModel;
import org.simantics.datatypes.literal.RGB;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.ui.CellValue;
import org.simantics.spreadsheet.ui.Spreadsheet;
import org.simantics.spreadsheet.ui.SpreadsheetTable;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.threads.AWTThread;

public final class ClientTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 226747623479756815L;
    private final ClientModel model;

    public ClientTableModel(ClientModel model) {
        this.model = model;
    }

    public void setTable(final SpreadsheetTable table) {
        this.model.addListener(new ClientModel.ClientModelListener(){
            private AtomicBoolean dirtyStructure = new AtomicBoolean(false);
            private AtomicBoolean dirtyHeaderSizes = new AtomicBoolean(false);
            private AtomicBoolean dirtyValues = new AtomicBoolean(false);

            public void columnLabels(String[] labels) {
                this.dirtyStructure.set(true);
            }

            public void rowLabels(String[] labels) {
                this.dirtyStructure.set(true);
            }

            public void rows(int amount) {
                this.dirtyStructure.set(true);
            }

            public void columns(int amount) {
                this.dirtyStructure.set(true);
            }

            public void columnWidths(int[] widths) {
                this.dirtyHeaderSizes.set(true);
            }

            public void cleared(String location) {
                this.dirtyValues.set(true);
            }

            public void propertyChange(String location, String property, Object value) {
                this.dirtyValues.set(true);
            }

            public void flush() {
                final boolean structure = this.dirtyStructure.compareAndSet(true, false);
                final boolean values = this.dirtyValues.compareAndSet(true, false);
                boolean headerSizes = this.dirtyHeaderSizes.compareAndSet(true, false);
                if (Spreadsheet.DEBUG) {
                    System.out.println("ClientTableModel.ClientModelListener.flush: structure=" + structure + ", values=" + values + ", headerSizes=" + headerSizes);
                }
                if (structure || values || headerSizes) {
                    AWTThread.getThreadAccess().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            int[] cc = table.getSelectedColumns();
                            int[] rc = table.getSelectedRows();
                            if (structure) {
                                ClientTableModel.this.fireTableStructureChanged();
                            }
                            if (values) {
                                ClientTableModel.this.fireTableDataChanged();
                            }
                            table.applyHeaderSizes(ClientTableModel.this.model);
                            if (rc.length == 1 && cc.length == 1) {
                                table.setColumnSelectionInterval(cc[0], cc[0]);
                                table.setRowSelectionInterval(rc[0], rc[0]);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public Object getValueAt(int row, int column) {
        String location = SpreadsheetUtils.cellName((int)row, (int)column);
        RGB.Integer foreground = (RGB.Integer)this.model.getPropertyAt(location, "foreground");
        Color foregroundColor = foreground != null ? Colors.awt((RGB.Integer)foreground) : null;
        RGB.Integer background = (RGB.Integer)this.model.getPropertyAt(location, "background");
        Color backgroundColor = background != null ? Colors.awt((RGB.Integer)background) : null;
        org.simantics.datatypes.literal.Font f = (org.simantics.datatypes.literal.Font)this.model.getPropertyAt(location, "font");
        Font font = f != null ? Fonts.awt((org.simantics.datatypes.literal.Font)f) : null;
        Integer border = (Integer)this.model.getPropertyAt(location, "border");
        int borderValue = border != null ? border : 0;
        Integer align = (Integer)this.model.getPropertyAt(location, "align");
        int alignValue = align != null ? align : 0;
        return new CellValue(SpreadsheetUtils.getLabel((ClientModel)this.model, (int)row, (int)column), font, foregroundColor, backgroundColor, borderValue, alignValue);
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumns();
    }

    @Override
    public String getColumnName(int column) {
        String[] names = (String[])this.model.getPropertyAt("Headers", "columnLabels");
        if (column < names.length) {
            return names[column];
        }
        return super.getColumnName(column);
    }

    @Override
    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.getRows();
    }
}

