/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.ui.Spreadsheet;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.collections.CollectionUtils;

public class ClientModelImpl
implements ClientModel {
    private final Map<String, Map<String, Object>> properties = new THashMap();
    private final Map<String, Map<String, Object>> cells = new THashMap();
    private int maxRow = 0;
    private int maxColumn = 0;
    private Set<String> clears = new HashSet<String>();
    private ArrayList<String> modLocation = new ArrayList();
    private ArrayList<String> modProperty = new ArrayList();
    private ArrayList<Object> modValue = new ArrayList();
    CopyOnWriteArrayList<ClientModel.ClientModelListener> listeners = new CopyOnWriteArrayList();
    private final Set<String> sizing = CollectionUtils.toSet((Object[])new String[]{"columnCount", "rowCount", "fitColumns", "fitRows"});

    public ClientModelImpl() {
        if (Spreadsheet.DEBUG) {
            System.out.println("SimpleContainerTableModel.init");
        }
        THashMap sheetDimensions = new THashMap();
        THashMap headers = new THashMap();
        THashMap excel = new THashMap();
        sheetDimensions.put("fitRows", false);
        sheetDimensions.put("fitColumns", false);
        sheetDimensions.put("columnCount", 0);
        sheetDimensions.put("rowCount", 0);
        excel.put("Visible", false);
        headers.put("columnWidths", new int[0]);
        headers.put("rowHeights", new int[0]);
        headers.put("columnLabels", new String[0]);
        headers.put("rowLabels", new String[0]);
        this.properties.put("Dimensions", (Map<String, Object>)sheetDimensions);
        this.properties.put("Headers", (Map<String, Object>)headers);
        this.properties.put("Excel", (Map<String, Object>)excel);
        this.setProperty("Excel", "Visible", false);
    }

    public void addListener(ClientModel.ClientModelListener listener) {
        this.listeners.add(listener);
        listener.rows(this.getRows());
        listener.columns(this.getColumns());
        listener.rowLabels((String[])this.getPropertyAt("Headers", "rowLabels"));
        listener.columnWidths((int[])this.getPropertyAt("Headers", "columnWidths"));
    }

    public void removeListener(ClientModel.ClientModelListener listener) {
        this.listeners.remove(listener);
    }

    private void fireFlush() {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.flush();
        }
    }

    private void fireRows() {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.rows(this.getRows());
        }
    }

    private void fireColumns() {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.columns(this.getColumns());
        }
    }

    private void fireColumnWidths() {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.columnWidths((int[])this.getPropertyAt("Headers", "columnWidths"));
        }
    }

    private void fireProperty(String location, String property, Object value) {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.propertyChange(location, property, value);
        }
    }

    private void fireCleared(String location) {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.cleared(location);
        }
    }

    public <T> T getPossiblePropertyAt(String location, String property) {
        try {
            T t = this.getPropertyAt(location, property);
            return t;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public synchronized <T> T getPropertyAt(String location, String property) {
        Map<String, Object> props;
        if (Spreadsheet.DEBUG) {
            System.out.println("SimpleContainerTableModel.getPropertyAt " + location + " " + property);
        }
        if ((props = this.properties.get(location)) != null) {
            return (T)props.get(property);
        }
        Map<String, Object> cls = this.cells.get(location);
        if (cls != null) {
            return (T)cls.get(property);
        }
        return null;
    }

    private boolean sizingProperty(String property) {
        return this.sizing.contains(property);
    }

    private boolean checkMaxRow(int row) {
        if (row + 1 > this.maxRow) {
            this.maxRow = row + 1;
            return true;
        }
        return false;
    }

    private boolean checkMaxColumn(int column) {
        if (column + 1 > this.maxColumn) {
            this.maxColumn = column + 1;
            return true;
        }
        return false;
    }

    public synchronized void setProperty(String location, String property, Object value) {
        assert (location != null);
        assert (property != null);
        this.modLocation.add(location);
        this.modProperty.add(property);
        this.modValue.add(value);
    }

    public synchronized void clear(String location) {
        this.clears.add(location);
    }

    public synchronized void flush() {
        for (String location : this.clears) {
            Map<String, Object> cls = this.cells.remove(location);
            if (cls == null) {
                return;
            }
            long l = SpreadsheetUtils.decodeCellCoded((String)location);
            int row = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            int column = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
            if (this.checkMaxRow(row)) {
                this.fireRows();
            }
            if (this.checkMaxColumn(column)) {
                this.fireColumns();
            }
            this.fireCleared(location);
        }
        int i = 0;
        while (i < this.modLocation.size()) {
            Map<String, Object> props;
            String location = this.modLocation.get(i);
            String property = this.modProperty.get(i);
            Object value = this.modValue.get(i);
            if (Spreadsheet.DEBUG) {
                System.out.println("ClientModelImpl.setProperty " + location + " " + property + " " + value);
            }
            if ((props = this.properties.get(location)) != null) {
                if (this.sizingProperty(property)) {
                    int currentRows = this.getRows();
                    int currentCols = this.getColumns();
                    props.put(property, value);
                    if (this.getRows() != currentRows) {
                        this.fireRows();
                    }
                    if (this.getColumns() != currentCols) {
                        this.fireColumns();
                    }
                } else {
                    props.put(property, value);
                    if (property.equals("columnWidths")) {
                        this.fireColumnWidths();
                    }
                }
            } else {
                Map<String, Object> cls = this.cells.get(location);
                if (cls == null) {
                    cls = new HashMap<String, Object>();
                    this.cells.put(location, cls);
                }
                cls.put(property, value);
                long l = SpreadsheetUtils.decodeCellCoded((String)location);
                int row = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                int column = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
                if (this.checkMaxRow(row)) {
                    this.fireRows();
                }
                if (this.checkMaxColumn(column)) {
                    this.fireColumns();
                }
            }
            this.fireProperty(location, property, value);
            ++i;
        }
        this.clears.clear();
        this.modLocation.clear();
        this.modProperty.clear();
        this.modValue.clear();
        this.fireFlush();
    }

    public int getRows() {
        boolean fitRows = (Boolean)this.getPropertyAt("Dimensions", "fitRows");
        if (fitRows) {
            return this.maxRow;
        }
        return (Integer)this.getPropertyAt("Dimensions", "rowCount");
    }

    public int getColumns() {
        boolean fitCols = (Boolean)this.getPropertyAt("Dimensions", "fitColumns");
        if (fitCols) {
            return this.maxColumn;
        }
        return (Integer)this.getPropertyAt("Dimensions", "columnCount");
    }

    public int[] getColumnWidths() {
        int[] data = (int[])this.getPropertyAt("Headers", "columnWidths");
        return (int[])data.clone();
    }

    public int[] getRowHeights() {
        int[] data = (int[])this.getPropertyAt("Headers", "rowHeights");
        return (int[])data.clone();
    }

    public Collection<Pair<String, Object>> listAll(String property) {
        Object value;
        ArrayList<Pair<String, Object>> result = new ArrayList<Pair<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : this.properties.entrySet()) {
            value = entry.getValue().get(property);
            if (value == null) continue;
            result.add((Pair<String, Object>)Pair.make((Object)entry.getKey(), (Object)value));
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.cells.entrySet()) {
            value = entry.getValue().get(property);
            if (value == null) continue;
            result.add((Pair<String, Object>)Pair.make((Object)entry.getKey(), (Object)value));
        }
        return result;
    }
}

