/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.document.ui.actions.AddDocumentAction;
import org.simantics.document.ui.dialogs.FileDetailDialog;
import org.simantics.document.ui.graphfile.FileDocumentUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ExceptionUtils;

public class ImportDocumentWithDetail
extends AddDocumentAction {
    public ImportDocumentWithDetail(ReadGraph graph, String relationUri) throws DatabaseException {
        super(graph, relationUri);
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                final FileDetailDialog dialog = new FileDetailDialog(Display.getCurrent().getActiveShell(), resource);
                if (dialog.open() == 1) {
                    dialog.getAnnotationConfigurator().dispose();
                    return;
                }
                final String filename = dialog.getFileName();
                final String name = dialog.getName();
                if (filename == null) {
                    dialog.getAnnotationConfigurator().dispose();
                    return;
                }
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        Resource newDoc = FileDocumentUtil.importFileWithName(graph, filename);
                        graph.claimLiteral(newDoc, l0.HasName, (Object)name);
                        ImportDocumentWithDetail.this.linkDocument(graph, resource, newDoc);
                        dialog.getAnnotationConfigurator().apply(graph, newDoc);
                    }
                }, (Callback)new Callback<DatabaseException>(){

                    public void run(DatabaseException parameter) {
                        dialog.getAnnotationConfigurator().dispose();
                        if (parameter != null) {
                            ExceptionUtils.logAndShowError((String)"Cannot import document.", (Throwable)parameter);
                        }
                    }
                });
            }
        };
    }
}

