/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.actions;

import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.actions.AddDocumentAction;
import org.simantics.document.ui.dialogs.UrlDetailDialog;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ExceptionUtils;

public class AddUrlDocumentWithDetail
extends AddDocumentAction {
    public AddUrlDocumentWithDetail(ReadGraph graph, String relationUri) throws DatabaseException {
        super(graph, relationUri);
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                final UrlDetailDialog dialog = new UrlDetailDialog(Display.getCurrent().getActiveShell(), resource);
                if (dialog.open() != 0) {
                    dialog.getAnnotationConfigurator().dispose();
                    return;
                }
                final String uriString = dialog.getUrl();
                final String name = dialog.getName();
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
                        Resource urlDocument = graph.newResource();
                        graph.claim(urlDocument, l0.InstanceOf, doc.UrlDocument);
                        graph.claimLiteral(urlDocument, l0.HasName, (Object)name);
                        graph.claimLiteral(urlDocument, doc.HasUrl, (Object)uriString);
                        AddUrlDocumentWithDetail.this.linkDocument(graph, resource, urlDocument);
                        dialog.getAnnotationConfigurator().apply(graph, urlDocument);
                    }
                }, (Callback)new Callback<DatabaseException>(){

                    public void run(DatabaseException parameter) {
                        dialog.getAnnotationConfigurator().dispose();
                        if (parameter != null) {
                            ExceptionUtils.logAndShowError((String)"Cannot add URL link.", (Throwable)parameter);
                        }
                    }
                });
            }
        };
    }
}

